"""
APIs provided by business-model-server1-1

generated by api_code_gen.py
  - **filename** : ``business_model.py``
  - **json timestamp** : ``2023-03-02 16:19:07``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.business_model import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable

import deepfos.api.business_model as last_ver

__all__ = ['BusinessModelAPI']


class ModelAPI(last_ver.ModelAPI):
    endpoint = '/business'

    @post('model')
    def save(self, logicTableInfo: BusinessModelDTOReq) -> Union[BusinessModelResultVO, Awaitable[BusinessModelResultVO]]:
        """
        业务模型-配置-基础配置-保存

        业务模型配置(不含权限)保存，使用场景：1、通过页面配置业务模型保存时
        使用
        """
        return {'body': logicTableInfo}


class ApprovalAPI(last_ver.ApprovalAPI):
    endpoint = '/business/model'



class DataAPI(ChildAPI):
    endpoint = '/business/model/data'

    @post('save')
    def save(self, modelDataSaveDTO: ModelDataSaveDTO) -> Union[List[ModelDataReturnDTO], Awaitable[List[ModelDataReturnDTO]]]:
        """
        基于业务模型的数据保存，应用场景：业务明细表使用视图保存。
        """
        return {'body': modelDataSaveDTO}


class ConfigureAPI(last_ver.ConfigureAPI):
    endpoint = '/business/model/form'

    @get('structure/top')
    def structure_top(self, elementName: str, folderId: str = None, path: str = None) -> Union[StructureDTO, Awaitable[StructureDTO]]:
        """
        业务模型-基础配置相关-主表配置查询接口

        object 含数据表信息、字段信息、业务主键、冗余字段等
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @get('structures')
    def structures(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[StructureDTO], Awaitable[List[StructureDTO]]]:
        """
        业务模型表-基础配置相关-查询接口模型元素

        list 含数据表信息、字段信息、业务主键、冗余字段等
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}


class PermissionAPI(last_ver.PermissionAPI):
    endpoint = '/business/model'



class BusinessModelAPI(DynamicRootAPI, builtin=True):
    """业务模型组件接口"""
    module_type = 'BCUB'
    default_version = (1, 0)
    multi_version = True
    cls_name = 'BusinessModelAPI'
    module_name = 'deepfos.api.V1_1.business_model'
    api_version = (1, 1)

    @cached_property
    def model(self) -> ModelAPI:
        """
        业务模型基础配置
        """
        return ModelAPI(self)

    @cached_property
    def approval(self) -> ApprovalAPI:
        """
        业务模型审批流相关接口
        """
        return ApprovalAPI(self)

    @cached_property
    def data(self) -> DataAPI:
        """
        业务模型数据相关接口
        """
        return DataAPI(self)

    @cached_property
    def configure(self) -> ConfigureAPI:
        """
        业务模型基本配置相关接口
        """
        return ConfigureAPI(self)

    @cached_property
    def permission(self) -> PermissionAPI:
        """
        业务模型权限配置
        """
        return PermissionAPI(self)


