# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_apps_create_app_request,
    build_apps_list_apps_request,
    build_apps_update_app_request,
    build_azure_regions_list_azure_regions_request,
    build_cdf_clusters_create_cdf_cluster_request,
    build_cdf_clusters_list_cdf_clusters_request,
    build_cdf_clusters_update_cdf_cluster_request,
    build_countries_list_countries_request,
    build_customers_add_customer_app_request,
    build_customers_create_customer_request,
    build_customers_create_tenant_request,
    build_customers_get_cdf_config_request,
    build_customers_get_customer_request,
    build_customers_list_customer_apps_request,
    build_customers_list_customer_tenants_request,
    build_customers_list_customers_request,
    build_customers_list_tenant_keys_request,
    build_customers_remove_customer_app_request,
    build_customers_update_cdf_config_request,
    build_customers_update_customer_request,
    build_customers_update_tenant_request,
    build_databases_update_databases_request,
    build_power_create_power_region_request,
    build_power_list_power_regions_by_country_request,
    build_tenants_list_tenants_details_request,
    build_user_get_user_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AppsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`apps` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_apps(self, **kwargs: Any) -> List[JSON]:
        """Internal Ignos api for listing apps.

        Internal Ignos api for listing apps.

        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "accessibleBySuppliers": bool,  # Required.
                        "description": "str",  # Required.
                        "id": "str",  # Required.
                        "key": "str",  # Required.
                        "name": "str",  # Required.
                        "privateApp": bool  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_apps_list_apps_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @overload
    async def create_app(
        self, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """

    @overload
    async def create_app(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """

    @distributed_trace_async
    async def create_app(self, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_apps_create_app_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def update_app(
        self, id: str, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "privateApp": bool  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """

    @overload
    async def update_app(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """

    @distributed_trace_async
    async def update_app(self, id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "accessibleBySuppliers": bool,  # Required.
                    "description": "str",  # Required.
                    "id": "str",  # Required.
                    "key": "str",  # Required.
                    "name": "str",  # Required.
                    "privateApp": bool  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_apps_update_app_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class AzureRegionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`azure_regions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_azure_regions(self, **kwargs: Any) -> List[JSON]:
        """list_azure_regions.

        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "displayName": "str",  # Required.
                        "name": "str",  # Required.
                        "regionDisplayName": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_azure_regions_list_azure_regions_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)


class CdfClustersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`cdf_clusters` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_cdf_clusters(self, **kwargs: Any) -> List[JSON]:
        """list_cdf_clusters.

        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "baseUrl": "str",  # Required.
                        "id": "str",  # Required.
                        "name": "str",  # Required.
                        "scope": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_cdf_clusters_list_cdf_clusters_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @overload
    async def create_cdf_cluster(
        self, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "baseUrl": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """

    @overload
    async def create_cdf_cluster(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def create_cdf_cluster(self, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """create_cdf_cluster.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_cdf_clusters_create_cdf_cluster_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def update_cdf_cluster(
        self, id: str, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "baseUrl": "str",  # Required.
                    "scope": "str"  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """

    @overload
    async def update_cdf_cluster(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def update_cdf_cluster(self, id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "baseUrl": "str",  # Required.
                    "id": "str",  # Required.
                    "name": "str",  # Required.
                    "scope": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_cdf_clusters_update_cdf_cluster_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class CountriesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`countries` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_countries(self, **kwargs: Any) -> List[JSON]:
        """list_countries.

        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "name": "str",  # Required.
                        "threeLetterISORegionName": "str",  # Required.
                        "twoLetterISORegionName": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_countries_list_countries_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)


class CustomersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`customers` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_customers(
        self, *, page_size: int = 100, continuation_token_parameter: Optional[str] = None, **kwargs: Any
    ) -> List[JSON]:
        """Internal Ignos api for listing customers.

        Internal Ignos api for listing customers.

        :keyword page_size: Default value is 100.
        :paramtype page_size: int
        :keyword continuation_token_parameter: Default value is None.
        :paramtype continuation_token_parameter: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "azureAdTenantId": "str",  # Optional.
                        "azureRegionId": "str",  # Required.
                        "azureRegionName": "str",  # Required.
                        "companyUrl": "str",  # Optional.
                        "contactPerson": {
                            "email": "str",  # Required.
                            "name": "str",  # Required.
                            "phone": "str"  # Required.
                        },
                        "country": "str",  # Required.
                        "customerManagedCdf": bool,  # Required.
                        "domain": "str",  # Optional.
                        "externalReference": "str",  # Optional.
                        "id": "str",  # Required.
                        "logoUrl": "str",  # Optional.
                        "name": "str",  # Required.
                        "numberOfTenants": 0,  # Required.
                        "shortName": "str",  # Required.
                        "status": "str",  # Required. Known values are: "Draft", "Active",
                          and "Deactivated".
                        "threeLetterIsoCountry": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_customers_list_customers_request(
            page_size=page_size,
            continuation_token_parameter=continuation_token_parameter,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @overload
    async def create_customer(
        self, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "shortName": "str",  # Required.
                    "threeLetterIsoCountry": "str"  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @overload
    async def create_customer(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def create_customer(self, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_customers_create_customer_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_customer(self, id: str, **kwargs: Any) -> JSON:
        """Internal Ignos api for getting a customer.

        Internal Ignos api for getting a customer.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_customers_get_customer_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def update_customer(
        self, id: str, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "azureAdTenantId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "threeLetterIsoCountry": "str"  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @overload
    async def update_customer(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def update_customer(self, id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Optional.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "country": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "domain": "str",  # Optional.
                    "externalReference": "str",  # Optional.
                    "id": "str",  # Required.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "numberOfTenants": 0,  # Required.
                    "shortName": "str",  # Required.
                    "status": "str",  # Required. Known values are: "Draft", "Active", and
                      "Deactivated".
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_customers_update_customer_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def list_customer_tenants(self, id: str, **kwargs: Any) -> List[JSON]:
        """Internal Ignos api for a customer's tenants.

        Internal Ignos api for a customer's tenants.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "azureAdTenantId": "str",  # Required.
                        "azureRegionId": "str",  # Required.
                        "azureRegionName": "str",  # Required.
                        "cdfTenant": "str",  # Optional.
                        "cdfTenantClientId": "str",  # Optional.
                        "companyUrl": "str",  # Optional.
                        "contactPerson": {
                            "email": "str",  # Required.
                            "name": "str",  # Required.
                            "phone": "str"  # Required.
                        },
                        "cosmosDatabase": "str",  # Optional.
                        "country": "str",  # Required.
                        "customerId": "str",  # Required.
                        "customerManagedCdf": bool,  # Required.
                        "customerName": "str",  # Required.
                        "customerShortName": "str",  # Required.
                        "description": "str",  # Optional.
                        "domain": "str",  # Optional.
                        "environment": "str",  # Required. Known values are: "Prod", "QA",
                          "Test", and "Dev".
                        "environmentName": "str",  # Required.
                        "externalReference": "str",  # Optional.
                        "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2,
                          and 9.
                        "logoUrl": "str",  # Optional.
                        "name": "str",  # Required.
                        "status": 0,  # Required.
                        "tenantId": "str",  # Required.
                        "tenantKey": "str",  # Optional.
                        "threeLetterIsoCountry": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_customers_list_customer_tenants_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @overload
    async def create_tenant(
        self, id: str, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "azureRegionId": "str",  # Required.
                    "cdfClusterId": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "description": "str",  # Optional.
                    "environment": "str"  # Required. Known values are: "Prod", "QA", "Test", and
                      "Dev".
                }

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @overload
    async def create_tenant(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def create_tenant(self, id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_customers_create_tenant_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "cdfTenant": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "description": "str"  # Optional.
                }

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """

    @distributed_trace_async
    async def update_tenant(
        self, id: str, tenant_id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureAdTenantId": "str",  # Required.
                    "azureRegionId": "str",  # Required.
                    "azureRegionName": "str",  # Required.
                    "cdfTenant": "str",  # Optional.
                    "cdfTenantClientId": "str",  # Optional.
                    "companyUrl": "str",  # Optional.
                    "contactPerson": {
                        "email": "str",  # Required.
                        "name": "str",  # Required.
                        "phone": "str"  # Required.
                    },
                    "cosmosDatabase": "str",  # Optional.
                    "country": "str",  # Required.
                    "customerId": "str",  # Required.
                    "customerManagedCdf": bool,  # Required.
                    "customerName": "str",  # Required.
                    "customerShortName": "str",  # Required.
                    "description": "str",  # Optional.
                    "domain": "str",  # Optional.
                    "environment": "str",  # Required. Known values are: "Prod", "QA", "Test",
                      and "Dev".
                    "environmentName": "str",  # Required.
                    "externalReference": "str",  # Optional.
                    "infrastructureStatus": 0,  # Required. Known values are: 0, 1, 2, and 9.
                    "logoUrl": "str",  # Optional.
                    "name": "str",  # Required.
                    "status": 0,  # Required.
                    "tenantId": "str",  # Required.
                    "tenantKey": "str",  # Optional.
                    "threeLetterIsoCountry": "str"  # Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_customers_update_tenant_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_cdf_config(self, id: str, tenant_id: str, **kwargs: Any) -> JSON:
        """Internal Ignos api for checking CDF config.

        Internal Ignos api for checking CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "clientId": "str",  # Optional.
                    "clientSecretExists": bool,  # Optional.
                    "tenantId": "str"  # Optional.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_customers_get_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "clientId": "str",  # Required.
                    "clientSecret": "str"  # Optional.
                }

                # response body for status code(s): 200
                response == {
                    "clientId": "str",  # Optional.
                    "clientSecretExists": bool,  # Optional.
                    "tenantId": "str"  # Optional.
                }
        """

    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "clientId": "str",  # Optional.
                    "clientSecretExists": bool,  # Optional.
                    "tenantId": "str"  # Optional.
                }
        """

    @distributed_trace_async
    async def update_cdf_config(
        self, id: str, tenant_id: str, body: Optional[Union[JSON, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "clientId": "str",  # Optional.
                    "clientSecretExists": bool,  # Optional.
                    "tenantId": "str"  # Optional.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_customers_update_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def list_customer_apps(self, id: str, **kwargs: Any) -> List[JSON]:
        """Internal Ignos api for listing customer apps.

        Internal Ignos api for listing customer apps.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "description": "str",  # Required.
                        "id": "str",  # Required.
                        "key": "str",  # Required.
                        "name": "str",  # Required.
                        "privateApp": bool  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_customers_list_customer_apps_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @distributed_trace_async
    async def add_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for adding an app to a customer.

        Internal Ignos api for adding an app to a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_customers_add_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def remove_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for removing an app from a customer.

        Internal Ignos api for removing an app from a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_customers_remove_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def list_tenant_keys(self, **kwargs: Any) -> List[JSON]:
        """list_tenant_keys.

        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "cdfTenant": "str",  # Optional.
                        "customerRowKey": "str",  # Optional.
                        "customerShortName": "str",  # Optional.
                        "key": "str",  # Optional.
                        "tenantId": "str",  # Optional.
                        "tenantRowKey": "str"  # Optional.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_customers_list_tenant_keys_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)


class DatabasesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`databases` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def update_databases(self, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """update_databases.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_databases_update_databases_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class PowerOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`power` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_power_regions_by_country(self, *, country: Optional[str] = None, **kwargs: Any) -> List[JSON]:
        """list_power_regions_by_country.

        :keyword country: Default value is None.
        :paramtype country: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "country": "str",  # Optional.
                        "description": "str",  # Optional.
                        "id": "str",  # Optional.
                        "region": "str"  # Optional.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_power_list_power_regions_by_country_request(
            country=country,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)

    @overload
    async def create_power_region(
        self, body: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """create_power_region.

        :param body: Default value is None.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "co2PerKwh": 0,  # Optional.
                    "country": "str",  # Required.
                    "description": "str",  # Required.
                    "initialCo2PerKwhDate": "2020-02-20 00:00:00",  # Optional.
                    "region": "str"  # Required.
                }

                # response body for status code(s): 200
                response == {
                    "country": "str",  # Optional.
                    "description": "str",  # Optional.
                    "id": "str",  # Optional.
                    "region": "str"  # Optional.
                }
        """

    @overload
    async def create_power_region(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """create_power_region.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "country": "str",  # Optional.
                    "description": "str",  # Optional.
                    "id": "str",  # Optional.
                    "region": "str"  # Optional.
                }
        """

    @distributed_trace_async
    async def create_power_region(self, body: Optional[Union[JSON, IO]] = None, **kwargs: Any) -> JSON:
        """create_power_region.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "country": "str",  # Optional.
                    "description": "str",  # Optional.
                    "id": "str",  # Optional.
                    "region": "str"  # Optional.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        request = build_power_create_power_region_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class TenantsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`tenants` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_tenants_details(
        self, *, tenant_id_prefix: Optional[str] = None, app_id: Optional[str] = None, **kwargs: Any
    ) -> List[JSON]:
        """Internal Ignos api for listing tenants.

        Internal Ignos api for listing tenants.

        :keyword tenant_id_prefix: Default value is None.
        :paramtype tenant_id_prefix: str
        :keyword app_id: Default value is None.
        :paramtype app_id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "apps": [
                            {
                                "description": "str",  # Required.
                                "id": "str",  # Required.
                                "key": "str",  # Required.
                                "name": "str",  # Required.
                                "privateApp": bool  # Required.
                            }
                        ],
                        "cdf": {
                            "baseUrl": "str",  # Required.
                            "clientId": "str",  # Required.
                            "clientSecretExists": bool,  # Required.
                            "customerManagedCdf": bool,  # Required.
                            "project": "str",  # Required.
                            "tokenScopes": "str",  # Required.
                            "tokenUrl": "str"  # Required.
                        },
                        "tenantId": "str"  # Required.
                    }
                ]
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[JSON]]

        request = build_tenants_list_tenants_details_request(
            tenant_id_prefix=tenant_id_prefix,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)


class UserOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`user` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_user(self, **kwargs: Any) -> JSON:
        """get_user.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "customerId": "str",  # Optional.
                    "fullName": "str",  # Optional.
                    "givenName": "str",  # Optional.
                    "id": "str",  # Optional.
                    "isExternalUser": bool,  # Optional.
                    "roles": [
                        "str"  # Optional.
                    ],
                    "surName": "str",  # Optional.
                    "tenantId": "str",  # Optional.
                    "upn": "str"  # Optional.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_user_get_user_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)
