# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core import PipelineClient
from azure.core.rest import HttpRequest, HttpResponse

from ._configuration import IgnosInternalApiConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AppsOperations,
    AzureRegionsOperations,
    CdfClustersOperations,
    CountriesOperations,
    CustomersOperations,
    DatabasesOperations,
    PowerOperations,
    TenantsOperations,
    UserOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Dict

    from azure.core.credentials import TokenCredential


class IgnosInternalApi:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """IgnosInternalApi.

    :ivar apps: AppsOperations operations
    :vartype apps: ignos.internal.api.client.operations.AppsOperations
    :ivar azure_regions: AzureRegionsOperations operations
    :vartype azure_regions: ignos.internal.api.client.operations.AzureRegionsOperations
    :ivar cdf_clusters: CdfClustersOperations operations
    :vartype cdf_clusters: ignos.internal.api.client.operations.CdfClustersOperations
    :ivar countries: CountriesOperations operations
    :vartype countries: ignos.internal.api.client.operations.CountriesOperations
    :ivar customers: CustomersOperations operations
    :vartype customers: ignos.internal.api.client.operations.CustomersOperations
    :ivar databases: DatabasesOperations operations
    :vartype databases: ignos.internal.api.client.operations.DatabasesOperations
    :ivar power: PowerOperations operations
    :vartype power: ignos.internal.api.client.operations.PowerOperations
    :ivar tenants: TenantsOperations operations
    :vartype tenants: ignos.internal.api.client.operations.TenantsOperations
    :ivar user: UserOperations operations
    :vartype user: ignos.internal.api.client.operations.UserOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :keyword endpoint: Service URL. Required. Default value is "".
    :paramtype endpoint: str
    """

    def __init__(self, credential: "TokenCredential", *, endpoint: str = "", **kwargs: Any) -> None:
        self._config = IgnosInternalApiConfiguration(credential=credential, **kwargs)
        self._client = PipelineClient(base_url=endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.apps = AppsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.azure_regions = AzureRegionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cdf_clusters = CdfClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.countries = CountriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.customers = CustomersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.databases = DatabasesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.power = PowerOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenants = TenantsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.user = UserOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> IgnosInternalApi
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
