#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright by: P.J. Grochowski

from abc import ABC, abstractmethod
from typing import List, Optional


class IMprisAdapterRoot(ABC):

    @abstractmethod
    def canRaise(self) -> bool: ...
    @abstractmethod
    def canQuit(self) -> bool: ...
    @abstractmethod
    def canSetFullscreen(self) -> bool: ...

    @abstractmethod
    def getIdentity(self) -> str: ...
    @abstractmethod
    def getDesktopEntry(self) -> Optional[str]: ...

    @abstractmethod
    def getSupportedUriSchemes(self) -> List[str]: ...
    @abstractmethod
    def getSupportedMimeTypes(self) -> List[str]: ...

    @abstractmethod
    def hasTracklist(self) -> bool: ...
    @abstractmethod
    def isFullScreen(self) -> bool: ...
    @abstractmethod
    def setFullScreen(self, value: bool) -> None: ...

    @abstractmethod
    def quitApp(self) -> None: ...
    @abstractmethod
    def raiseApp(self) -> None: ...
