#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright by: P.J. Grochowski

from abc import ABC, abstractmethod
from typing import Optional

from tunit.unit import Microseconds

from mpris_api.model.MprisLoopStatus import MprisLoopStatus
from mpris_api.model.MprisMetaData import MprisMetaData
from mpris_api.model.MprisPlaybackStatus import MprisPlaybackStatus


class IMprisAdapterPlayer(ABC):

    DEFAULT_MIN_RATE: float = 1.0
    DEFAULT_MAX_RATE: float = 1.0
    DEFAULT_RATE: float = 1.0
    MIN_VOLUME: float = 0.0
    MAX_VOLUME: float = 1.0

    @abstractmethod
    def canControl(self) -> bool: ...
    @abstractmethod
    def canPlay(self) -> bool: ...
    @abstractmethod
    def canPause(self) -> bool: ...
    @abstractmethod
    def canGoNext(self) -> bool: ...
    @abstractmethod
    def canGoPrevious(self) -> bool: ...
    @abstractmethod
    def canSeek(self) -> bool: ...

    @abstractmethod
    def getMinimumRate(self) -> float: ...
    @abstractmethod
    def getMaximumRate(self) -> float: ...
    @abstractmethod
    def getRate(self) -> float: ...
    @abstractmethod
    def setRate(self, value: float) -> None: ...

    @abstractmethod
    def getVolume(self) -> float: ...
    @abstractmethod
    def setVolume(self, value: float) -> None: ...

    @abstractmethod
    def getMetadata(self) -> MprisMetaData: ...
    @abstractmethod
    def getPlaybackStatus(self) -> MprisPlaybackStatus: ...
    @abstractmethod
    def getPosition(self) -> Microseconds: ...

    @abstractmethod
    def getLoopStatus(self) -> MprisLoopStatus: ...
    @abstractmethod
    def setLoopStatus(self, value: MprisLoopStatus) -> None: ...
    @abstractmethod
    def isShuffle(self) -> bool: ...
    @abstractmethod
    def setShuffle(self, value: bool) -> None: ...

    @abstractmethod
    def stop(self) -> None: ...
    @abstractmethod
    def play(self) -> None: ...
    @abstractmethod
    def pause(self) -> None: ...
    @abstractmethod
    def next(self) -> None: ...
    @abstractmethod
    def previous(self) -> None: ...
    @abstractmethod
    def seek(self, position: Microseconds, trackId: Optional[str] = None) -> None: ...
    @abstractmethod
    def openUri(self, uri: str) -> None: ...
