# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, conlist, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, conlist, validator

class Statement(BaseModel):
    """
    Statement
    """
    effect: StrictStr = Field(...)
    resource: StrictStr = Field(...)
    action: conlist(StrictStr, min_items=1) = Field(...)
    __properties = ["effect", "resource", "action"]

    @validator('effect')
    def effect_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('allow', 'deny'):
            raise ValueError("must be one of enum values ('allow', 'deny')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Statement:
        """Create an instance of Statement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Statement:
        """Create an instance of Statement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Statement.parse_obj(obj)

        _obj = Statement.parse_obj({
            "effect": obj.get("effect"),
            "resource": obj.get("resource"),
            "action": obj.get("action")
        })
        return _obj


