# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, conlist

class PresignMultipartUpload(BaseModel):
    """
    PresignMultipartUpload
    """
    upload_id: StrictStr = Field(...)
    physical_address: StrictStr = Field(...)
    presigned_urls: Optional[conlist(StrictStr)] = None
    __properties = ["upload_id", "physical_address", "presigned_urls"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PresignMultipartUpload:
        """Create an instance of PresignMultipartUpload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PresignMultipartUpload:
        """Create an instance of PresignMultipartUpload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PresignMultipartUpload.parse_obj(obj)

        _obj = PresignMultipartUpload.parse_obj({
            "upload_id": obj.get("upload_id"),
            "physical_address": obj.get("physical_address"),
            "presigned_urls": obj.get("presigned_urls")
        })
        return _obj


