# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictInt, StrictStr

class DiffObjectStat(BaseModel):
    """
    DiffObjectStat
    """
    checksum: StrictStr = Field(...)
    mtime: StrictInt = Field(..., description="Unix Epoch in seconds")
    content_type: StrictStr = Field(..., description="Object media type")
    metadata: Optional[Dict[str, StrictStr]] = None
    __properties = ["checksum", "mtime", "content_type", "metadata"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DiffObjectStat:
        """Create an instance of DiffObjectStat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DiffObjectStat:
        """Create an instance of DiffObjectStat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DiffObjectStat.parse_obj(obj)

        _obj = DiffObjectStat.parse_obj({
            "checksum": obj.get("checksum"),
            "mtime": obj.get("mtime"),
            "content_type": obj.get("content_type"),
            "metadata": obj.get("metadata")
        })
        return _obj


