# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from lakefs_sdk.models.diff_object_stat import DiffObjectStat

class Diff(BaseModel):
    """
    Diff
    """
    type: StrictStr = Field(...)
    path: StrictStr = Field(...)
    path_type: StrictStr = Field(...)
    size_bytes: Optional[StrictInt] = Field(None, description="represents the size of the added/changed/deleted entry")
    right: Optional[DiffObjectStat] = None
    __properties = ["type", "path", "path_type", "size_bytes", "right"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('added', 'removed', 'changed', 'conflict', 'prefix_changed'):
            raise ValueError("must be one of enum values ('added', 'removed', 'changed', 'conflict', 'prefix_changed')")
        return value

    @validator('path_type')
    def path_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('common_prefix', 'object'):
            raise ValueError("must be one of enum values ('common_prefix', 'object')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Diff:
        """Create an instance of Diff from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of right
        if self.right:
            _dict['right'] = self.right.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Diff:
        """Create an instance of Diff from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Diff.parse_obj(obj)

        _obj = Diff.parse_obj({
            "type": obj.get("type"),
            "path": obj.get("path"),
            "path_type": obj.get("path_type"),
            "size_bytes": obj.get("size_bytes"),
            "right": DiffObjectStat.from_dict(obj.get("right")) if obj.get("right") is not None else None
        })
        return _obj


