# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, validator

class PullRequest(BaseModel):
    """
    PullRequest
    """
    status: StrictStr = Field(...)
    title: StrictStr = Field(...)
    description: StrictStr = Field(...)
    id: StrictStr = Field(...)
    creation_date: datetime = Field(...)
    author: StrictStr = Field(...)
    source_branch: StrictStr = Field(...)
    destination_branch: StrictStr = Field(...)
    merged_commit_id: Optional[StrictStr] = Field(None, description="the commit id of merged PRs")
    closed_date: Optional[datetime] = None
    __properties = ["status", "title", "description", "id", "creation_date", "author", "source_branch", "destination_branch", "merged_commit_id", "closed_date"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('open', 'closed', 'merged'):
            raise ValueError("must be one of enum values ('open', 'closed', 'merged')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PullRequest:
        """Create an instance of PullRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PullRequest:
        """Create an instance of PullRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PullRequest.parse_obj(obj)

        _obj = PullRequest.parse_obj({
            "status": obj.get("status"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "creation_date": obj.get("creation_date"),
            "author": obj.get("author"),
            "source_branch": obj.get("source_branch"),
            "destination_branch": obj.get("destination_branch"),
            "merged_commit_id": obj.get("merged_commit_id"),
            "closed_date": obj.get("closed_date")
        })
        return _obj


