# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, conlist
from lakefs_sdk.models.usage_report import UsageReport

class InstallationUsageReport(BaseModel):
    """
    InstallationUsageReport
    """
    installation_id: StrictStr = Field(...)
    reports: conlist(UsageReport) = Field(...)
    __properties = ["installation_id", "reports"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstallationUsageReport:
        """Create an instance of InstallationUsageReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in reports (list)
        _items = []
        if self.reports:
            for _item in self.reports:
                if _item:
                    _items.append(_item.to_dict())
            _dict['reports'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstallationUsageReport:
        """Create an instance of InstallationUsageReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstallationUsageReport.parse_obj(obj)

        _obj = InstallationUsageReport.parse_obj({
            "installation_id": obj.get("installation_id"),
            "reports": [UsageReport.from_dict(_item) for _item in obj.get("reports")] if obj.get("reports") is not None else None
        })
        return _obj


