# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, validator

class HookRun(BaseModel):
    """
    HookRun
    """
    hook_run_id: StrictStr = Field(...)
    action: StrictStr = Field(...)
    hook_id: StrictStr = Field(...)
    start_time: datetime = Field(...)
    end_time: Optional[datetime] = None
    status: StrictStr = Field(...)
    __properties = ["hook_run_id", "action", "hook_id", "start_time", "end_time", "status"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('failed', 'completed'):
            raise ValueError("must be one of enum values ('failed', 'completed')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HookRun:
        """Create an instance of HookRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HookRun:
        """Create an instance of HookRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return HookRun.parse_obj(obj)

        _obj = HookRun.parse_obj({
            "hook_run_id": obj.get("hook_run_id"),
            "action": obj.get("action"),
            "hook_id": obj.get("hook_id"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "status": obj.get("status")
        })
        return _obj


