# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist

class CommitRecordCreation(BaseModel):
    """
    CommitRecordCreation
    """
    commit_id: StrictStr = Field(..., description="id of the commit record")
    version: conint(strict=True, le=1, ge=0) = Field(..., description="version of the commit record")
    committer: StrictStr = Field(..., description="committer of the commit record")
    message: StrictStr = Field(..., description="message of the commit record")
    metarange_id: StrictStr = Field(..., description="metarange_id of the commit record")
    creation_date: StrictInt = Field(..., description="Unix Epoch in seconds")
    parents: conlist(StrictStr) = Field(..., description="parents of the commit record")
    metadata: Optional[Dict[str, StrictStr]] = Field(None, description="metadata of the commit record")
    generation: StrictInt = Field(..., description="generation of the commit record")
    force: Optional[StrictBool] = False
    __properties = ["commit_id", "version", "committer", "message", "metarange_id", "creation_date", "parents", "metadata", "generation", "force"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CommitRecordCreation:
        """Create an instance of CommitRecordCreation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CommitRecordCreation:
        """Create an instance of CommitRecordCreation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CommitRecordCreation.parse_obj(obj)

        _obj = CommitRecordCreation.parse_obj({
            "commit_id": obj.get("commit_id"),
            "version": obj.get("version"),
            "committer": obj.get("committer"),
            "message": obj.get("message"),
            "metarange_id": obj.get("metarange_id"),
            "creation_date": obj.get("creation_date"),
            "parents": obj.get("parents"),
            "metadata": obj.get("metadata"),
            "generation": obj.get("generation"),
            "force": obj.get("force") if obj.get("force") is not None else False
        })
        return _obj


