"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpJwtAuthorizer {
    /**
     * (experimental) Initialize a JWT authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param jwtIssuer The base domain of the identity provider that issues JWT.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id, jwtIssuer, props) {
        this.id = id;
        this.jwtIssuer = jwtIssuer;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpJwtAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        if (!this.authorizer) {
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpJwtAuthorizer", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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