# ExApp
A Python Example Launcher Application

![](https://github.com/allinpy/ExApp/raw/main/doc/source/_static/ExApp_window.png)

## Overview
ExApp is a Python-based application designed to streamline the process of running Python scripts. It's an ideal tool for developers and users who frequently test or demonstrate multiple Python scripts. By simply executing `python -m exapp <target_folder>`, ExApp initiates a user-friendly, explorer-like interface that allows for the seamless execution of .py files located within the specified target folder.

## Features
- **Explorer-Like Interface**: Navigate through your Python scripts as you would in a file explorer, providing a familiar and intuitive user experience.
- **One-Click Execution**: Run any `.py` file with a single click, eliminating the need to manually enter script paths or commands in the terminal.
- **Folder Specific Search**: Specify the target folder to focus on the scripts relevant to your current project or demonstration.
- **Lightweight and Easy-to-Use**: Designed with simplicity in mind, ExApp is straightforward to set up and operate, requiring minimal configuration.

## Installation and Usage
1. **Installation**: Download the ExApp package and install it using Python. Ensure that Python is correctly installed on your system.
2. **Launching the Application**: Open a terminal or command prompt and navigate to the ExApp directory. Run the application with the command `python -m exapp <target_folder>`, where `<target_folder>` is the path to the folder containing your Python scripts.
3. **Using ExApp**: Once launched, ExApp displays all `.py` files in the specified folder. Click on any script to run it, and view the output directly within the ExApp interface.

## Requirements
- Python: Make sure you have Python installed on your system.
- Dependencies: ExApp relies on standard Python libraries, ensuring compatibility and ease of use.

## Support and Contribution
For support, questions, or contributions, please visit our GitHub repository. We welcome feedback and contributions to improve ExApp and expand its capabilities.

ExApp offers a convenient and efficient way to run and demonstrate Python scripts, tailored for both developers and casual users. Try it out and streamline your Python script execution process!
