import datetime
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, OSIDBModel, Unset

if TYPE_CHECKING:
    from ..models.exploits_api_v1_report_pending_retrieve_response_200_pending_actions_item import (
        ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem,
    )


T = TypeVar("T", bound="ExploitsApiV1ReportPendingRetrieveResponse200")


@_attrs_define
class ExploitsApiV1ReportPendingRetrieveResponse200(OSIDBModel):
    """
    Attributes:
        dt (Union[Unset, datetime.datetime]):
        env (Union[Unset, str]):
        pending_actions (Union[Unset, list['ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem']]):
        pending_actions_count (Union[Unset, int]):
        revision (Union[Unset, str]):
        version (Union[Unset, str]):
    """

    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    pending_actions: Union[
        Unset, list["ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem"]
    ] = UNSET
    pending_actions_count: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env

        pending_actions: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.pending_actions, Unset):
            pending_actions = []
            for pending_actions_item_data in self.pending_actions:
                pending_actions_item: dict[str, Any] = UNSET
                if not isinstance(pending_actions_item_data, Unset):
                    pending_actions_item = pending_actions_item_data.to_dict()

                pending_actions.append(pending_actions_item)

        pending_actions_count = self.pending_actions_count

        revision = self.revision

        version = self.version

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if not isinstance(dt, Unset):
            field_dict["dt"] = dt
        if not isinstance(env, Unset):
            field_dict["env"] = env
        if not isinstance(pending_actions, Unset):
            field_dict["pending_actions"] = pending_actions
        if not isinstance(pending_actions_count, Unset):
            field_dict["pending_actions_count"] = pending_actions_count
        if not isinstance(revision, Unset):
            field_dict["revision"] = revision
        if not isinstance(version, Unset):
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        from ..models.exploits_api_v1_report_pending_retrieve_response_200_pending_actions_item import (
            ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem,
        )

        d = src_dict.copy()
        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        pending_actions = []
        _pending_actions = d.pop("pending_actions", UNSET)
        for pending_actions_item_data in _pending_actions or []:
            _pending_actions_item = pending_actions_item_data
            pending_actions_item: (
                ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem
            )
            if isinstance(_pending_actions_item, Unset):
                pending_actions_item = UNSET
            else:
                pending_actions_item = ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem.from_dict(
                    _pending_actions_item
                )

            pending_actions.append(pending_actions_item)

        pending_actions_count = d.pop("pending_actions_count", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_report_pending_retrieve_response_200 = cls(
            dt=dt,
            env=env,
            pending_actions=pending_actions,
            pending_actions_count=pending_actions_count,
            revision=revision,
            version=version,
        )

        exploits_api_v1_report_pending_retrieve_response_200.additional_properties = d
        return exploits_api_v1_report_pending_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "dt": datetime.datetime,
            "env": str,
            "pending_actions": list[
                "ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem"
            ],
            "pending_actions_count": int,
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
