import datetime
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, OSIDBModel, Unset

if TYPE_CHECKING:
    from ..models.exploits_api_v1_report_date_retrieve_response_200_action_required_item import (
        ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem,
    )
    from ..models.exploits_api_v1_report_date_retrieve_response_200_no_action_item import (
        ExploitsApiV1ReportDateRetrieveResponse200NoActionItem,
    )
    from ..models.exploits_api_v1_report_date_retrieve_response_200_not_relevant_item import (
        ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem,
    )


T = TypeVar("T", bound="ExploitsApiV1ReportDateRetrieveResponse200")


@_attrs_define
class ExploitsApiV1ReportDateRetrieveResponse200(OSIDBModel):
    """
    Attributes:
        action_required (Union[Unset, list['ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem']]):
        cutoff_date (Union[Unset, str]):
        dt (Union[Unset, datetime.datetime]):
        env (Union[Unset, str]):
        evaluated_cves (Union[Unset, int]):
        no_action (Union[Unset, list['ExploitsApiV1ReportDateRetrieveResponse200NoActionItem']]):
        not_relevant (Union[Unset, list['ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem']]):
        revision (Union[Unset, str]):
        version (Union[Unset, str]):
    """

    action_required: Union[
        Unset, list["ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem"]
    ] = UNSET
    cutoff_date: Union[Unset, str] = UNSET
    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    evaluated_cves: Union[Unset, int] = UNSET
    no_action: Union[
        Unset, list["ExploitsApiV1ReportDateRetrieveResponse200NoActionItem"]
    ] = UNSET
    not_relevant: Union[
        Unset, list["ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem"]
    ] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        action_required: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.action_required, Unset):
            action_required = []
            for action_required_item_data in self.action_required:
                action_required_item: dict[str, Any] = UNSET
                if not isinstance(action_required_item_data, Unset):
                    action_required_item = action_required_item_data.to_dict()

                action_required.append(action_required_item)

        cutoff_date = self.cutoff_date

        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env

        evaluated_cves = self.evaluated_cves

        no_action: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.no_action, Unset):
            no_action = []
            for no_action_item_data in self.no_action:
                no_action_item: dict[str, Any] = UNSET
                if not isinstance(no_action_item_data, Unset):
                    no_action_item = no_action_item_data.to_dict()

                no_action.append(no_action_item)

        not_relevant: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.not_relevant, Unset):
            not_relevant = []
            for not_relevant_item_data in self.not_relevant:
                not_relevant_item: dict[str, Any] = UNSET
                if not isinstance(not_relevant_item_data, Unset):
                    not_relevant_item = not_relevant_item_data.to_dict()

                not_relevant.append(not_relevant_item)

        revision = self.revision

        version = self.version

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if not isinstance(action_required, Unset):
            field_dict["action_required"] = action_required
        if not isinstance(cutoff_date, Unset):
            field_dict["cutoff_date"] = cutoff_date
        if not isinstance(dt, Unset):
            field_dict["dt"] = dt
        if not isinstance(env, Unset):
            field_dict["env"] = env
        if not isinstance(evaluated_cves, Unset):
            field_dict["evaluated_cves"] = evaluated_cves
        if not isinstance(no_action, Unset):
            field_dict["no_action"] = no_action
        if not isinstance(not_relevant, Unset):
            field_dict["not_relevant"] = not_relevant
        if not isinstance(revision, Unset):
            field_dict["revision"] = revision
        if not isinstance(version, Unset):
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        from ..models.exploits_api_v1_report_date_retrieve_response_200_action_required_item import (
            ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem,
        )
        from ..models.exploits_api_v1_report_date_retrieve_response_200_no_action_item import (
            ExploitsApiV1ReportDateRetrieveResponse200NoActionItem,
        )
        from ..models.exploits_api_v1_report_date_retrieve_response_200_not_relevant_item import (
            ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem,
        )

        d = src_dict.copy()
        action_required = []
        _action_required = d.pop("action_required", UNSET)
        for action_required_item_data in _action_required or []:
            _action_required_item = action_required_item_data
            action_required_item: (
                ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem
            )
            if isinstance(_action_required_item, Unset):
                action_required_item = UNSET
            else:
                action_required_item = ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem.from_dict(
                    _action_required_item
                )

            action_required.append(action_required_item)

        cutoff_date = d.pop("cutoff_date", UNSET)

        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        evaluated_cves = d.pop("evaluated_cves", UNSET)

        no_action = []
        _no_action = d.pop("no_action", UNSET)
        for no_action_item_data in _no_action or []:
            _no_action_item = no_action_item_data
            no_action_item: ExploitsApiV1ReportDateRetrieveResponse200NoActionItem
            if isinstance(_no_action_item, Unset):
                no_action_item = UNSET
            else:
                no_action_item = (
                    ExploitsApiV1ReportDateRetrieveResponse200NoActionItem.from_dict(
                        _no_action_item
                    )
                )

            no_action.append(no_action_item)

        not_relevant = []
        _not_relevant = d.pop("not_relevant", UNSET)
        for not_relevant_item_data in _not_relevant or []:
            _not_relevant_item = not_relevant_item_data
            not_relevant_item: ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem
            if isinstance(_not_relevant_item, Unset):
                not_relevant_item = UNSET
            else:
                not_relevant_item = (
                    ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem.from_dict(
                        _not_relevant_item
                    )
                )

            not_relevant.append(not_relevant_item)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_report_date_retrieve_response_200 = cls(
            action_required=action_required,
            cutoff_date=cutoff_date,
            dt=dt,
            env=env,
            evaluated_cves=evaluated_cves,
            no_action=no_action,
            not_relevant=not_relevant,
            revision=revision,
            version=version,
        )

        exploits_api_v1_report_date_retrieve_response_200.additional_properties = d
        return exploits_api_v1_report_date_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "action_required": list[
                "ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem"
            ],
            "cutoff_date": str,
            "dt": datetime.datetime,
            "env": str,
            "evaluated_cves": int,
            "no_action": list["ExploitsApiV1ReportDateRetrieveResponse200NoActionItem"],
            "not_relevant": list[
                "ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem"
            ],
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
