import datetime
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, OSIDBModel, Unset

if TYPE_CHECKING:
    from ..models.exploits_api_v1_cve_map_retrieve_response_200_cves import (
        ExploitsApiV1CveMapRetrieveResponse200Cves,
    )


T = TypeVar("T", bound="ExploitsApiV1CveMapRetrieveResponse200")


@_attrs_define
class ExploitsApiV1CveMapRetrieveResponse200(OSIDBModel):
    """
    Attributes:
        cves (Union[Unset, ExploitsApiV1CveMapRetrieveResponse200Cves]):
        dt (Union[Unset, datetime.datetime]):
        env (Union[Unset, str]):
        page_size (Union[Unset, int]):
        revision (Union[Unset, str]):
        version (Union[Unset, str]):
    """

    cves: Union[Unset, "ExploitsApiV1CveMapRetrieveResponse200Cves"] = UNSET
    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    page_size: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        cves: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.cves, Unset):
            cves = self.cves.to_dict()

        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env

        page_size = self.page_size

        revision = self.revision

        version = self.version

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if not isinstance(cves, Unset):
            field_dict["cves"] = cves
        if not isinstance(dt, Unset):
            field_dict["dt"] = dt
        if not isinstance(env, Unset):
            field_dict["env"] = env
        if not isinstance(page_size, Unset):
            field_dict["page_size"] = page_size
        if not isinstance(revision, Unset):
            field_dict["revision"] = revision
        if not isinstance(version, Unset):
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        from ..models.exploits_api_v1_cve_map_retrieve_response_200_cves import (
            ExploitsApiV1CveMapRetrieveResponse200Cves,
        )

        d = src_dict.copy()
        _cves = d.pop("cves", UNSET)
        cves: Union[Unset, ExploitsApiV1CveMapRetrieveResponse200Cves]
        if isinstance(_cves, Unset):
            cves = UNSET
        else:
            cves = ExploitsApiV1CveMapRetrieveResponse200Cves.from_dict(_cves)

        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        page_size = d.pop("page_size", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_cve_map_retrieve_response_200 = cls(
            cves=cves,
            dt=dt,
            env=env,
            page_size=page_size,
            revision=revision,
            version=version,
        )

        exploits_api_v1_cve_map_retrieve_response_200.additional_properties = d
        return exploits_api_v1_cve_map_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "cves": ExploitsApiV1CveMapRetrieveResponse200Cves,
            "dt": datetime.datetime,
            "env": str,
            "page_size": int,
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
