import datetime
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.exploit_only_report_data_source_enum import (
    ExploitOnlyReportDataSourceEnum,
)
from ..models.maturity_preliminary_enum import MaturityPreliminaryEnum
from ..types import UNSET, OSIDBModel, Unset

T = TypeVar("T", bound="ExploitOnlyReportData")


@_attrs_define
class ExploitOnlyReportData(OSIDBModel):
    """
    Attributes:
        cve (str):
        source (ExploitOnlyReportDataSourceEnum):
        maturity_preliminary (MaturityPreliminaryEnum):
        flaw (bool):
        date (Union[None, Unset, datetime.date]):
        reference (Union[Unset, str]):  Default: 'N/A'.
    """

    cve: str
    source: ExploitOnlyReportDataSourceEnum
    maturity_preliminary: MaturityPreliminaryEnum
    flaw: bool
    date: Union[None, Unset, datetime.date] = UNSET
    reference: Union[Unset, str] = "N/A"
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        cve = self.cve

        source: str = UNSET
        if not isinstance(self.source, Unset):
            source = ExploitOnlyReportDataSourceEnum(self.source).value

        maturity_preliminary: int = UNSET
        if not isinstance(self.maturity_preliminary, Unset):
            maturity_preliminary = MaturityPreliminaryEnum(
                self.maturity_preliminary
            ).value

        flaw = self.flaw

        date: Union[None, Unset, str]
        if isinstance(self.date, Unset):
            date = UNSET
        elif isinstance(self.date, datetime.date):
            date = UNSET
            if not isinstance(self.date, Unset):
                date = self.date.isoformat()

        else:
            date = self.date

        reference = self.reference

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if not isinstance(cve, Unset):
            field_dict["cve"] = cve
        if not isinstance(source, Unset):
            field_dict["source"] = source
        if not isinstance(maturity_preliminary, Unset):
            field_dict["maturity_preliminary"] = maturity_preliminary
        if not isinstance(flaw, Unset):
            field_dict["flaw"] = flaw
        if not isinstance(date, Unset):
            field_dict["date"] = date
        if not isinstance(reference, Unset):
            field_dict["reference"] = reference

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        cve = d.pop("cve", UNSET)

        _source = d.pop("source", UNSET)
        source: ExploitOnlyReportDataSourceEnum
        if isinstance(_source, Unset):
            source = UNSET
        else:
            source = ExploitOnlyReportDataSourceEnum(_source)

        _maturity_preliminary = d.pop("maturity_preliminary", UNSET)
        maturity_preliminary: MaturityPreliminaryEnum
        if isinstance(_maturity_preliminary, Unset):
            maturity_preliminary = UNSET
        else:
            maturity_preliminary = MaturityPreliminaryEnum(_maturity_preliminary)

        flaw = d.pop("flaw", UNSET)

        def _parse_date(data: object) -> Union[None, Unset, datetime.date]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                _date_type_0 = data
                date_type_0: datetime.date
                if isinstance(_date_type_0, Unset):
                    date_type_0 = UNSET
                else:
                    date_type_0 = isoparse(_date_type_0).date()

                return date_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.date], data)

        date = _parse_date(d.pop("date", UNSET))

        reference = d.pop("reference", UNSET)

        exploit_only_report_data = cls(
            cve=cve,
            source=source,
            maturity_preliminary=maturity_preliminary,
            flaw=flaw,
            date=date,
            reference=reference,
        )

        exploit_only_report_data.additional_properties = d
        return exploit_only_report_data

    @staticmethod
    def get_fields():
        return {
            "cve": str,
            "source": ExploitOnlyReportDataSourceEnum,
            "maturity_preliminary": MaturityPreliminaryEnum,
            "flaw": bool,
            "date": Union[None, datetime.date],
            "reference": str,
        }

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
