from http import HTTPStatus
from typing import Any, Optional, Union

import requests

from ...client import AuthenticatedClient, Client
from ...models.exploits_api_v1_report_explanations_retrieve_response_200 import (
    ExploitsApiV1ReportExplanationsRetrieveResponse200,
)
from ...types import UNSET, Response, Unset

QUERY_PARAMS = {}


def _get_kwargs(
    *,
    client: AuthenticatedClient,
) -> dict[str, Any]:
    headers: dict[str, Any] = client.get_headers()

    _kwargs: dict[str, Any] = {
        "url": f"{client.base_url}/exploits/api/v1/report/explanations",
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Optional[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1ReportExplanationsRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1ReportExplanationsRetrieveResponse200.from_dict(
                _response_200
            )

        return response_200


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    r"""API endpoint for getting a report of all CVEs with exploit and their status
    for Incident Response.

    Format of results:
    ```
    {
       \"page_size\": <Number of CVEs on the page>,
       \"explanations\": [<List of CVEs with exploit together with current status explanation>],
    }
    ```

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    r"""API endpoint for getting a report of all CVEs with exploit and their status
    for Incident Response.

    Format of results:
    ```
    {
       \"page_size\": <Number of CVEs on the page>,
       \"explanations\": [<List of CVEs with exploit together with current status explanation>],
    }
    ```

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV1ReportExplanationsRetrieveResponse200
    """

    return sync_detailed(
        client=client,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    r"""API endpoint for getting a report of all CVEs with exploit and their status
    for Incident Response.

    Format of results:
    ```
    {
       \"page_size\": <Number of CVEs on the page>,
       \"explanations\": [<List of CVEs with exploit together with current status explanation>],
    }
    ```

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        client=client,
    )

    async with client.get_async_session().get(
        verify_ssl=client.verify_ssl, raise_for_status=True, **kwargs
    ) as response:
        content = await response.read()
        resp = requests.Response()
        resp.status_code = response.status
        resp._content = content

    return _build_response(client=client, response=resp)


async def asyncio(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    r"""API endpoint for getting a report of all CVEs with exploit and their status
    for Incident Response.

    Format of results:
    ```
    {
       \"page_size\": <Number of CVEs on the page>,
       \"explanations\": [<List of CVEs with exploit together with current status explanation>],
    }
    ```

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV1ReportExplanationsRetrieveResponse200
    """

    return (
        await asyncio_detailed(
            client=client,
        )
    ).parsed
