# ariestools

Common tools

[source code](https://github.com/JFRabbit/ariestools)

### Install
pip install -U ariestools

### Python version support
python3.7+

### Function

> graphql query
```python
from ariestools import graphql_query

_res_json = graphql_query(query_url, payload)
```

> json path
```python
from ariestools import JsonPath

_json_dict = {'k': 'v'}
_jp1 = JsonPath(_json_dict)
print(_jp1.path("$.k"))

_json_list = [{'k': 'v'}]
_jp2 = JsonPath(_json_list)
print(_jp2.path("$.[0].k"))

_json_complex = {'k': [{'k': 'v'}]}
_jp3 = JsonPath(_json_complex)

print(_jp3.path("$.k.[0].k"))
```

> load json file
```python
from ariestools import load_json
_json = load_json(json_file_path)
```

> format obj to json str
```python
from ariestools.json_util import obj2jsonstr


class Foo:
    def __init__(self):
        self.a = 1
        self.b = 2
        self.bar = Bar()

class Bar:
    def __init__(self):
        self.x = 1
        self.y = 2


print(obj2jsonstr(Foo()))
```
``` json
{
    "a": 1,
    "b": 2,
    "bar": {
        "x": 1,
        "y": 2
    }
}
```

> get relative path & load yaml
```python
import os
from ariestools import replace_sys_path, load_yaml

_yaml = load_yaml(os.path.realpath('') + replace_sys_path("/.xxx/xxx.yaml"))
```

> parse time
```python
t_time_str = '2019-08-01 00:00:00.000'
t_dt = parse(t_time_str) # 2019-08-01T00:00:00+08:00

print(get_local_time(t_dt)) # 2019-08-01 00:00:00.000
print(get_cloud_time(t_dt)) # 1564588800000000000

t_time_str2 = '2019-08-01 00:00:05.000'
t_dt2 = parse(t_time_str2)

print(get_dt_duration_seconds(t_dt2, t_dt)) # 5

print(t_dt2 > t_dt) # True

print(now()) # 1576224515111
```