# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['Client']

# %% ../nbs/00_core.ipynb 3
import pandas as pd
from bs4 import BeautifulSoup
from tqdm import tqdm
import os
import requests
import json
import time

# %% ../nbs/00_core.ipynb 4
class Client:
    @staticmethod
    def main(endpoint, csv_path, property_id, identity, credential):
        client = Client(identity, credential)
        client.download(endpoint, csv_path, property_id)
        client.analyze()
        client.delete()
        client.upload()


    def __init__(self, identity, credential):
        # self.api_endpoint = api_endpoint
        self.identity = identity
        self.credential = credential
        pass

    def download(self, endpoint, csv_path, property_id, debug=False):
        print("*", "item json download")
        self.endpoint = endpoint
        self.csv_path = csv_path

        ###

        df = pd.read_csv(self.csv_path)

        # 登録前のアイテム毎のマップ
        before = {}
        self.before = before

        for index, row in df.iterrows():
            id = row["Item Identifier"]
            url = row["Media Url"]

            if id not in before:
                before[id] = []
            before[id].append(url)

        after = {}

        count = 0
        size = len(before)

        missings = {}
        self.missings = missings

        skip = False

        for id in tqdm(before):
            
            count += 1

            path = "tmp/" + id + ".json"
            os.makedirs(os.path.dirname(path), exist_ok=True)

            # jsonファイルがない場合にはダウンロード
            if not os.path.exists(path) or not skip:

                api = f"{self.endpoint}/items?property%5B0%5D%5Bproperty%5D={property_id}&property%5B0%5D%5Btype%5D=eq&property%5B0%5D%5Btext%5D={id}&key_identity={self.identity}&key_credential={self.credential}"
                
                if debug:
                    print(api)
                
                df = requests.get(api).json()

                with open(path, mode='wt', encoding='utf-8') as file:
                    json.dump(df, file, ensure_ascii=False, indent=2)

            with open(path, mode='rt', encoding='utf-8') as file:
                df = json.load(file)

                if len(df) > 0:
                    item = df[0]

                    after[id] = len(item["o:media"])

                    bsize = len(before[id])

                    if bsize != after[id]:
                        missings[id] = {
                            "before": bsize,
                            "after":after[id],
                            "oid" : item["o:id"]
                        }

        opath = "data/missings.json"

        os.makedirs(os.path.dirname(opath), exist_ok=True)

        with open(opath, mode='wt', encoding='utf-8') as file:
            json.dump(missings, file, ensure_ascii=False, indent=2)

    def analyze(self):
        print("*", "media json download")
        df = pd.read_csv(self.csv_path)

        # 登録前のアイテム毎のマップ
        before = self.before
        missings = self.missings

        rows = []
        rows.append(["item id", "omeka id", "登録前画像数", "登録後画像数", "不足画像数", "不足画像URL"])

        size = len(missings)

        count = 0

        for uuid in tqdm(missings):

            count += 1

            # print(count, size, uuid)

            item = missings[uuid]

            oid = item["oid"]

            api = f"{self.endpoint}/media?item_id=" + str(oid)

            page = 1

            flg = True

            urls = []

            while flg:

                url = api + "&page={}".format(page)

                df = requests.get(url).json()

                if len(df) == 0:
                    flg = False

                for res in df:
                    source = res["o:source"]

                    urls.append(source)

                page += 1

            b_images = before[uuid]

            # print(urls, b_images)

            l = ", ".join(sorted(list(set(b_images).difference(set(urls)))))

            if l == "":
                continue

            missings[uuid]["l"] = l.split(", ")

            rows.append([uuid, oid, item["before"], item["after"], item["before"] - item["after"], l])

        df = pd.DataFrame(rows)
        df.to_csv('data/missings.csv', header=False, index=False)

        

    def delete(self):
        print("*", "delete media")
        missings = self.missings

        for item_id in tqdm(missings):

            missing = missings[item_id]

            if missing["after"] == 0:
                continue

            if item_id not in self.before:
                continue

            with open(f"tmp/{item_id}.json", mode='rt', encoding='utf-8') as file:
                ts = json.load(file)

            t = ts[0]

            medias = t["o:media"]

            medias_removed = medias # [index:] # 削除はすべて

            for m in tqdm(medias_removed):

                media_uri = f'{m["@id"]}?key_identity={self.identity}&key_credential={self.credential}'

                response = requests.delete(url=media_uri)

    def upload(self, debug=False, loop=5, property_id=11):
        print("*", "upload media")
        missings = self.missings
        before = self.before

        final_uri = f'{self.endpoint}/items?key_identity={self.identity}&key_credential={self.credential}'

        finised = []

        for item_id in tqdm(missings):

            if debug:
                print("item_id", item_id)

            exit_flg = False

            if item_id not in before:
                continue

            if item_id in finised:
                continue

            bb = before[item_id]

            with open(f"tmp/{item_id}.json", mode='rt', encoding='utf-8') as file:
                ts = json.load(file)

            t = ts[0]

            oid = t["o:id"]

            # 登録対象の画像
            cc = bb

            # print(item_id)

            for iiif in tqdm(cc):

                if debug:
                    print("iiif", iiif)

                item_payload = {
                    "o:source": iiif,
                    "o:item": {
                        "o:id": oid
                    },
                    "o:ingester": "iiif",
                    "o:renderer": "iiif",
                    "@type": "o:Media",
                    "dcterms:source": [
                        {
                            "property_id": property_id, 
                            "@value": iiif, 
                            "type" : "literal"
                        }
                    ]
                }

                url = final_uri.replace("/api/items", "/api/media")

                # print(url)

                r = requests.post(url, json=item_payload)

                if r.status_code != 200:
                    print("failed", item_id, oid, r.status_code, r.text, iiif)

                    # もう一回試みる
                    count = 0

                    while 1:
                        time.sleep(1)

                        r = requests.post(url, json=item_payload)

                        if r.status_code == 200:
                            break

                        count += 1

                        if count > loop:
                            exit_flg = True
                            break

            if debug:
                break

            if exit_flg:
                continue

            finised.append(item_id)
