"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const waf = require("@aws-cdk/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
/**
 * @summary The WafwebaclToApiGateway class.
 */
class WafwebaclToApiGateway extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToApiGatewayProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'REGIONAL', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        const resourceArn = `arn:aws:apigateway:${core_1.Stack.of(scope).region}::/restapis/${props.existingApiGatewayInterface.restApiId}/stages/${props.existingApiGatewayInterface.deploymentStage.stageName}`;
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn
        });
        this.apiGateway = props.existingApiGatewayInterface;
    }
}
exports.WafwebaclToApiGateway = WafwebaclToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-apigateway.WafwebaclToApiGateway", version: "1.169.0" };
//# sourceMappingURL=data:application/json;base64,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