# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-05-02 07:13
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='PyOTP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, help_text='Non-editable, to be generated by system itself.', unique=True, verbose_name='OTP Unique uuid')),
                ('secret', models.CharField(help_text='Secret used to generate OTP.', max_length=50, verbose_name='Secret')),
                ('count', models.IntegerField(blank=True, help_text='OTP Count, to be used in case of HOTP.', null=True, verbose_name='Count')),
                ('interval', models.IntegerField(blank=True, help_text='OTP Count, to be used in case of TOTP.', null=True, verbose_name='Interval (in seconds)')),
                ('otp', models.CharField(help_text='Generated OTP.', max_length=10, verbose_name='OTP')),
                ('name', models.CharField(blank=True, help_text='Account Name for Provisioning URI, to be used when need URI for QR code.', max_length=255, null=True, verbose_name='Account Name')),
                ('initial_count', models.IntegerField(blank=True, help_text='Initial Count for Provisioning URI.', null=True, verbose_name='Initial Count')),
                ('issuer_name', models.CharField(blank=True, help_text='Issuer Name for Provisioning URI.', max_length=255, null=True, verbose_name='Issuer Name')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
            ],
            options={
                'verbose_name': 'PyOtp',
                'verbose_name_plural': 'PyOtp',
            },
        ),
    ]
