# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class V1RuntimeMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'model_uri': 'str',
        'deployment_name': 'str',
        'deployment_namespace': 'str',
        'deployment_kubernetes_uid': 'str',
        'predictor_name': 'str',
        'node_name': 'str',
        'deployment_status': 'V1DeploymentStatus',
        'deployment_type': 'V1DeploymentType',
        'traffic': 'str',
        'shadow': 'bool',
        'creation_time': 'datetime'
    }

    attribute_map = {
        'model_uri': 'modelUri',
        'deployment_name': 'deploymentName',
        'deployment_namespace': 'deploymentNamespace',
        'deployment_kubernetes_uid': 'deploymentKubernetesUid',
        'predictor_name': 'predictorName',
        'node_name': 'nodeName',
        'deployment_status': 'deploymentStatus',
        'deployment_type': 'deploymentType',
        'traffic': 'traffic',
        'shadow': 'shadow',
        'creation_time': 'creationTime'
    }

    def __init__(self, model_uri=None, deployment_name=None, deployment_namespace=None, deployment_kubernetes_uid=None, predictor_name=None, node_name=None, deployment_status=None, deployment_type=None, traffic=None, shadow=None, creation_time=None):  # noqa: E501
        """V1RuntimeMetadata - a model defined in Swagger"""  # noqa: E501

        self._model_uri = None
        self._deployment_name = None
        self._deployment_namespace = None
        self._deployment_kubernetes_uid = None
        self._predictor_name = None
        self._node_name = None
        self._deployment_status = None
        self._deployment_type = None
        self._traffic = None
        self._shadow = None
        self._creation_time = None
        self.discriminator = None

        if model_uri is not None:
            self.model_uri = model_uri
        if deployment_name is not None:
            self.deployment_name = deployment_name
        if deployment_namespace is not None:
            self.deployment_namespace = deployment_namespace
        if deployment_kubernetes_uid is not None:
            self.deployment_kubernetes_uid = deployment_kubernetes_uid
        if predictor_name is not None:
            self.predictor_name = predictor_name
        if node_name is not None:
            self.node_name = node_name
        if deployment_status is not None:
            self.deployment_status = deployment_status
        if deployment_type is not None:
            self.deployment_type = deployment_type
        if traffic is not None:
            self.traffic = traffic
        if shadow is not None:
            self.shadow = shadow
        if creation_time is not None:
            self.creation_time = creation_time

    @property
    def model_uri(self):
        """Gets the model_uri of this V1RuntimeMetadata.  # noqa: E501

        The URI for the storage bucket containing the model, or the URI to the docker image for custom models.  # noqa: E501

        :return: The model_uri of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._model_uri

    @model_uri.setter
    def model_uri(self, model_uri):
        """Sets the model_uri of this V1RuntimeMetadata.

        The URI for the storage bucket containing the model, or the URI to the docker image for custom models.  # noqa: E501

        :param model_uri: The model_uri of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._model_uri = model_uri

    @property
    def deployment_name(self):
        """Gets the deployment_name of this V1RuntimeMetadata.  # noqa: E501

        The name of the Kubernetes deployment that is associated with a model.  # noqa: E501

        :return: The deployment_name of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._deployment_name

    @deployment_name.setter
    def deployment_name(self, deployment_name):
        """Sets the deployment_name of this V1RuntimeMetadata.

        The name of the Kubernetes deployment that is associated with a model.  # noqa: E501

        :param deployment_name: The deployment_name of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._deployment_name = deployment_name

    @property
    def deployment_namespace(self):
        """Gets the deployment_namespace of this V1RuntimeMetadata.  # noqa: E501

        The Kubernetes namespace in which this deployment is running in.  # noqa: E501

        :return: The deployment_namespace of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._deployment_namespace

    @deployment_namespace.setter
    def deployment_namespace(self, deployment_namespace):
        """Sets the deployment_namespace of this V1RuntimeMetadata.

        The Kubernetes namespace in which this deployment is running in.  # noqa: E501

        :param deployment_namespace: The deployment_namespace of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._deployment_namespace = deployment_namespace

    @property
    def deployment_kubernetes_uid(self):
        """Gets the deployment_kubernetes_uid of this V1RuntimeMetadata.  # noqa: E501

        The Kubernetes UID of the deployment associated with a model. See https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids for details  # noqa: E501

        :return: The deployment_kubernetes_uid of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._deployment_kubernetes_uid

    @deployment_kubernetes_uid.setter
    def deployment_kubernetes_uid(self, deployment_kubernetes_uid):
        """Sets the deployment_kubernetes_uid of this V1RuntimeMetadata.

        The Kubernetes UID of the deployment associated with a model. See https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids for details  # noqa: E501

        :param deployment_kubernetes_uid: The deployment_kubernetes_uid of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._deployment_kubernetes_uid = deployment_kubernetes_uid

    @property
    def predictor_name(self):
        """Gets the predictor_name of this V1RuntimeMetadata.  # noqa: E501

        The name of the predictor inside the deployment that contains the referenced model.  # noqa: E501

        :return: The predictor_name of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._predictor_name

    @predictor_name.setter
    def predictor_name(self, predictor_name):
        """Sets the predictor_name of this V1RuntimeMetadata.

        The name of the predictor inside the deployment that contains the referenced model.  # noqa: E501

        :param predictor_name: The predictor_name of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._predictor_name = predictor_name

    @property
    def node_name(self):
        """Gets the node_name of this V1RuntimeMetadata.  # noqa: E501

        The name of the node inside the predictor that contains the referenced model. This is relevant and populated only for SeldonDeployment deployment types.  # noqa: E501

        :return: The node_name of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """Sets the node_name of this V1RuntimeMetadata.

        The name of the node inside the predictor that contains the referenced model. This is relevant and populated only for SeldonDeployment deployment types.  # noqa: E501

        :param node_name: The node_name of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._node_name = node_name

    @property
    def deployment_status(self):
        """Gets the deployment_status of this V1RuntimeMetadata.  # noqa: E501

        The status of the Kubernetes deployment associated with a model.  # noqa: E501

        :return: The deployment_status of this V1RuntimeMetadata.  # noqa: E501
        :rtype: V1DeploymentStatus
        """
        return self._deployment_status

    @deployment_status.setter
    def deployment_status(self, deployment_status):
        """Sets the deployment_status of this V1RuntimeMetadata.

        The status of the Kubernetes deployment associated with a model.  # noqa: E501

        :param deployment_status: The deployment_status of this V1RuntimeMetadata.  # noqa: E501
        :type: V1DeploymentStatus
        """

        self._deployment_status = deployment_status

    @property
    def deployment_type(self):
        """Gets the deployment_type of this V1RuntimeMetadata.  # noqa: E501

        The type of deployment - either SeldonDeployment or InferenceService.  # noqa: E501

        :return: The deployment_type of this V1RuntimeMetadata.  # noqa: E501
        :rtype: V1DeploymentType
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """Sets the deployment_type of this V1RuntimeMetadata.

        The type of deployment - either SeldonDeployment or InferenceService.  # noqa: E501

        :param deployment_type: The deployment_type of this V1RuntimeMetadata.  # noqa: E501
        :type: V1DeploymentType
        """

        self._deployment_type = deployment_type

    @property
    def traffic(self):
        """Gets the traffic of this V1RuntimeMetadata.  # noqa: E501

        The amount of traffic server by this model in the deployment.  # noqa: E501

        :return: The traffic of this V1RuntimeMetadata.  # noqa: E501
        :rtype: str
        """
        return self._traffic

    @traffic.setter
    def traffic(self, traffic):
        """Sets the traffic of this V1RuntimeMetadata.

        The amount of traffic server by this model in the deployment.  # noqa: E501

        :param traffic: The traffic of this V1RuntimeMetadata.  # noqa: E501
        :type: str
        """

        self._traffic = traffic

    @property
    def shadow(self):
        """Gets the shadow of this V1RuntimeMetadata.  # noqa: E501

        True if this model is a shadow in the deployment.  # noqa: E501

        :return: The shadow of this V1RuntimeMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._shadow

    @shadow.setter
    def shadow(self, shadow):
        """Sets the shadow of this V1RuntimeMetadata.

        True if this model is a shadow in the deployment.  # noqa: E501

        :param shadow: The shadow of this V1RuntimeMetadata.  # noqa: E501
        :type: bool
        """

        self._shadow = shadow

    @property
    def creation_time(self):
        """Gets the creation_time of this V1RuntimeMetadata.  # noqa: E501

        The creation timestamp for the runtime model metadata entry. It is automatically created by the Metadata service and cannot be modified. The timestamp is using the [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format/  # noqa: E501

        :return: The creation_time of this V1RuntimeMetadata.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this V1RuntimeMetadata.

        The creation timestamp for the runtime model metadata entry. It is automatically created by the Metadata service and cannot be modified. The timestamp is using the [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format/  # noqa: E501

        :param creation_time: The creation_time of this V1RuntimeMetadata.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V1RuntimeMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1RuntimeMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
