# coding: utf-8

"""
    gnomock

    `gnomock` is an HTTP wrapper for [Gnomock](https://github.com/orlangure/gnomock) integration and end-to-end testing toolkit. It allows to use Gnomock outside of Go ecosystem. Not all Gnomock features exist in this wrapper, but official presets, as well as basic general configuration, are supported.   # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gnomock.configuration import Configuration


class Container(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'host': 'str',
        'ports': 'dict(str, object)'
    }

    attribute_map = {
        'id': 'id',
        'host': 'host',
        'ports': 'ports'
    }

    def __init__(self, id=None, host='localhost', ports=None, local_vars_configuration=None):  # noqa: E501
        """Container - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._host = None
        self._ports = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if host is not None:
            self.host = host
        if ports is not None:
            self.ports = ports

    @property
    def id(self):
        """Gets the id of this Container.  # noqa: E501

        Container ID (same as in docker)  # noqa: E501

        :return: The id of this Container.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Container.

        Container ID (same as in docker)  # noqa: E501

        :param id: The id of this Container.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def host(self):
        """Gets the host of this Container.  # noqa: E501

        Host of bound ports  # noqa: E501

        :return: The host of this Container.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this Container.

        Host of bound ports  # noqa: E501

        :param host: The host of this Container.  # noqa: E501
        :type: str
        """

        self._host = host

    @property
    def ports(self):
        """Gets the ports of this Container.  # noqa: E501

        A map of port bindings of a Gnomock container. Human readable names are used to make the values readable. `port` value is an actual port exposed on the host; use this port to connect to the container.   # noqa: E501

        :return: The ports of this Container.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this Container.

        A map of port bindings of a Gnomock container. Human readable names are used to make the values readable. `port` value is an actual port exposed on the host; use this port to connect to the container.   # noqa: E501

        :param ports: The ports of this Container.  # noqa: E501
        :type: dict(str, object)
        """

        self._ports = ports

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Container):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Container):
            return True

        return self.to_dict() != other.to_dict()
