"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const index_1 = require("./index");
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack');
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = new aws_ec2_1.Vpc(stack, 'nat', {
    natGateways: 1,
    maxAzs: 2,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    vpcSubnet: {
        subnetType: aws_ec2_1.SubnetType.PRIVATE,
    },
});
runner.expireAfter(core_1.Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFrom(aws_ec2_1.Peer.ipv4('0.0.0.0/0'), aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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