# Auto-generated by Xeda

create_project -part {{settings.fpga.part}} -force -verbose {{design.name}}

set design_name           {{design.name}}
set vhdl_std              {{design.language.vhdl.standard}}

{% include 'util.tcl' %}

set_param general.maxThreads {{settings.nthreads}}

puts "\n=====================( Read Design Files and Constraints )====================="
{% for src in design.rtl.sources -%}
{% if src.type == 'systemverilog' -%}
puts "Reading SystemVerilog file {{src.file}}"
if { [catch {eval read_verilog -sv {{src.file}} } myError]} {
    errorExit $myError
}
{%- elif src.type == 'verilog' %}
puts "Reading Verilog file {{src.file}}"
if { [catch {eval read_verilog {{src.file}} } myError]} {
    errorExit $myError
}
{%- elif src.type == 'vhdl' %}
puts "Reading VHDL file {{src.file}}"
if { [catch {eval read_vhdl {% if design.language.vhdl.standard == "08" or design.language.vhdl.standard == "2008" %} -vhdl2008 {%- endif %} {{src.file}} } myError]} {
    errorExit $myError
}
{%- endif %}
{%- endfor %}

{% for xdc_file in xdc_files %}
read_xdc {{xdc_file}}
{% endfor %}

set_property top {{design.rtl.top}} [get_fileset sources_1]

set avail_synth_strategies [join [list_property_value strategy [get_runs synth_1] ] " "]
puts "available synthesis strategies: $avail_synth_strategies"

{% if settings.synth.strategy %}
puts "setting synthesis strategy to {{settings.synth.strategy}}"
set_property strategy {{settings.synth.strategy}} [get_runs synth_1]
{% endif %}


set avail_impl_strategies [join [list_property_value strategy [get_runs impl_1] ] " "]
puts "available implementation strategies: $avail_impl_strategies"

{% if settings.impl.strategy -%}
puts "setting implementation strategy to {{settings.impl.strategy}}"
set_property strategy {{settings.impl.strategy}} [get_runs impl_1]
{% endif -%}

{% for k,v in design.rtl.parameters.items() -%}
{% set x = "1'b%d" % v if v is boolean else v if v is match("\\d+'b[01]+") else "\\\"" + v + "\\\"" if v is string else v -%}
set_property generic {% raw -%} { {%- endraw -%} {{ k }}={{ x }} {%- raw -%} } {%- endraw %} [current_fileset]
{% endfor -%}

#{# see https://www.xilinx.com/support/documentation/sw_manuals/xilinx2020_2/ug912-vivado-properties.pdf #}
#{# and https://www.xilinx.com/support/documentation/sw_manuals/xilinx2020_2/ug835-vivado-tcl-commands.pdf #}
{% for step,options in settings.synth.steps.items() -%}
{% for name,value in options.items() -%}
{% if value is mapping %}
{% for k,v in value.items() %}
set_property STEPS.{{step}}.{{name}}.{{k}} {{v}} [get_runs synth_1]
{% endfor -%}
{% else %}
set_property STEPS.{{step}}.{{name}} {{value}} [get_runs synth_1]
{% endif %}
{% endfor -%}
{% endfor -%}

{% for step,options in settings.impl.steps.items() -%}
{% for name,value in options.items() -%}
{% if value is mapping %}
{% for k,v in value.items() %}
set_property STEPS.{{step}}.{{name}}.{{k}} {{v}} [get_runs impl_1]
{% endfor -%}
{% else %}
set_property STEPS.{{step}}.{{name}} {{value}} [get_runs impl_1]
{% endif %}
{% endfor -%}
{% endfor -%}

add_files -fileset utils_1 -norecurse [pwd]/{{reports_tcl}}
set_property STEPS.ROUTE_DESIGN.TCL.POST [pwd]/{{reports_tcl}} [get_runs impl_1]

create_report_config -report_type report_utilization -report_name post_opt_report        -steps opt_design   -runs [get_runs impl_1] -options {-format xml}
create_report_config -report_type report_utilization -report_name post_opt_hier_report   -steps opt_design   -runs [get_runs impl_1] -options {-hierarchical -format xml}
create_report_config -report_type report_utilization -report_name post_route_report      -steps route_design -runs [get_runs impl_1] -options {-format xml}
create_report_config -report_type report_utilization -report_name post_route_hier_report -steps route_design -runs [get_runs impl_1] -options {-hierarchical -format xml}

puts "\n=============================( Running Synthesis )============================="
launch_runs synth_1 -jobs {{settings.nthreads}}
wait_on_run synth_1
# renamed to wait_on_runs in Vivado 2021.2?!!

puts "\n===========================( Running Implementation )=========================="
launch_runs impl_1 -jobs {{settings.nthreads}} {%- if not settings.write_bitstream %} -to_step route_design {%- endif %}
wait_on_run impl_1

puts "\n====================================( DONE )==================================="
