# -*- coding:utf-8 -*-


import pandas as pd
import numpy as np
import requests
import time, json, urllib.parse

from hawkdata.utils.crawlers import WebCrawlerBase


class CStatsCrawler(WebCrawlerBase):

    QUERY_URL = 'https://data.stats.gov.cn/easyquery.htm'

    __instance = None

    def __new__(self, *args, **kw):

        if self.__instance is None:
            self.__instance = object.__new__(self, *args, **kw)

        return self.__instance

    def __init__(self):

        pass

    def macro_china_yearly_gdp(self):

        yearly_gdp_df = pd.DataFrame(
            np.array([[1978, 3678.7],
                      [1979, 4100.5],
                      [1980, 4587.6],
                      [1981, 4935.8],
                      [1982, 5373.4],
                      [1983, 6020.9],
                      [1984, 7278.5],
                      [1985, 9098.9],
                      [1986, 10376.2],
                      [1987, 12174.6],
                      [1988, 15180.4],
                      [1989, 17179.7],
                      [1990, 18872.9],
                      [1991, 22005.6],
                      [1992, 27194.5],
                      [1993, 35673.2],
                      [1994, 48637.5],
                      [1995, 61339.9],
                      [1996, 71813.6],
                      [1997, 79715.0],
                      [1998, 85195.5],
                      [1999, 90564.4],
                      [2000, 100280.1],
                      [2001, 110863.1],
                      [2002, 121717.4],
                      [2003, 137422.0],
                      [2004, 161840.2],
                      [2005, 187318.9],
                      [2006, 219438.5],
                      [2007, 270092.3],
                      [2008, 319244.6],
                      [2009, 348517.7],
                      [2010, 412119.3],
                      [2011, 487940.2],
                      [2012, 538580.0],
                      [2013, 592963.2],
                      [2014, 643563.1],
                      [2015, 688858.2],
                      [2016, 746395.1],
                      [2017, 832035.9],
                      [2018, 919281.1],
                      [2019, 986515.2],
                      [2020, 1015986.2]]),
            columns=['year', 'gdp'])

        yearly_gdp_df = yearly_gdp_df.astype({
            'year': 'int',
            'gdp': 'float64'
        })

        return yearly_gdp_df

    def macro_china_yearly_gdp_yoy(self):

        yearly_gdp_yoy_df = pd.DataFrame(
            np.array([[1978, 111.7],
                      [1979, 107.6],
                      [1980, 107.8],
                      [1981, 105.1],
                      [1982, 109.0],
                      [1983, 110.8],
                      [1984, 115.2],
                      [1985, 113.4],
                      [1986, 108.9],
                      [1987, 111.7],
                      [1988, 111.2],
                      [1989, 104.2],
                      [1990, 103.9],
                      [1991, 109.3],
                      [1992, 114.2],
                      [1993, 113.9],
                      [1994, 113.0],
                      [1995, 111.0],
                      [1996, 109.9],
                      [1997, 109.2],
                      [1998, 107.8],
                      [1999, 107.7],
                      [2000, 108.5],
                      [2001, 108.3],
                      [2002, 109.1],
                      [2003, 110.0],
                      [2004, 110.1],
                      [2005, 111.4],
                      [2006, 112.7],
                      [2007, 114.2],
                      [2008, 109.7],
                      [2009, 109.4],
                      [2010, 110.6],
                      [2011, 109.6],
                      [2012, 107.9],
                      [2013, 107.8],
                      [2014, 107.4],
                      [2015, 107.0],
                      [2016, 106.8],
                      [2017, 106.9],
                      [2018, 106.7],
                      [2019, 106.0],
                      [2020, 102.3]]),
            columns=['year', 'gdp_yoy'])

        yearly_gdp_yoy_df = yearly_gdp_yoy_df.astype({
            'year': 'int',
            'gdp_yoy': 'float64'
        })

        return yearly_gdp_yoy_df

    def macro_china_yearly_gdp_index(self):

        yearly_gdp_index_df = pd.DataFrame(
            np.array([[1978, 100.0],
                      [1979, 107.6],
                      [1980, 116.0],
                      [1981, 122.0],
                      [1982, 132.9],
                      [1983, 147.3],
                      [1984, 169.6],
                      [1985, 192.4],
                      [1986, 209.6],
                      [1987, 234.1],
                      [1988, 260.4],
                      [1989, 271.3],
                      [1990, 281.9],
                      [1991, 308.1],
                      [1992, 351.9],
                      [1993, 400.7],
                      [1994, 453.0],
                      [1995, 502.6],
                      [1996, 552.5],
                      [1997, 603.5],
                      [1998, 650.8],
                      [1999, 700.7],
                      [2000, 760.2],
                      [2001, 823.6],
                      [2002, 898.8],
                      [2003, 989.0],
                      [2004, 1089.0],
                      [2005, 1213.1],
                      [2006, 1367.4],
                      [2007, 1562.0],
                      [2008, 1712.8],
                      [2009, 1873.8],
                      [2010, 2073.1],
                      [2011, 2271.1],
                      [2012, 2449.6],
                      [2013, 2639.9],
                      [2014, 2835.9],
                      [2015, 3035.6],
                      [2016, 3243.5],
                      [2017, 3468.8],
                      [2018, 3703.0],
                      [2019, 3923.3],
                      [2020, 4015.4]]),
            columns=['year', 'gdp_index'])

        yearly_gdp_index_df = yearly_gdp_index_df.astype({
            'year': 'int',
            'gdp_index': 'float64'
        })

        return yearly_gdp_index_df

    def macro_china_quarterly_gdp(self):

        quarterly_gdp_df = pd.DataFrame(
            np.array([['1992-03-31', 5262.8],
                      ['1992-06-30', 6484.3],
                      ['1992-09-30', 7192.6],
                      ['1992-12-31', 8254.8],
                      ['1993-03-31', 6834.6],
                      ['1993-06-30', 8357.0],
                      ['1993-09-30', 9385.8],
                      ['1993-12-31', 11095.9],
                      ['1994-03-31', 9375.1],
                      ['1994-06-30', 11481.0],
                      ['1994-09-30', 12868.0],
                      ['1994-12-31', 14913.3],
                      ['1995-03-31', 12111.7],
                      ['1995-06-30', 14612.9],
                      ['1995-09-30', 16164.1],
                      ['1995-12-31', 18451.2],
                      ['1996-03-31', 14628.0],
                      ['1996-06-30', 17147.5],
                      ['1996-09-30', 18605.8],
                      ['1996-12-31', 21432.4],
                      ['1997-03-31', 16689.1],
                      ['1997-06-30', 19163.6],
                      ['1997-09-30', 20500.9],
                      ['1997-12-31', 23361.5],
                      ['1998-03-31', 18049.1],
                      ['1998-06-30', 20296.6],
                      ['1998-09-30', 21775.6],
                      ['1998-12-31', 25074.2],
                      ['1999-03-31', 19361.9],
                      ['1999-06-30', 21567.7],
                      ['1999-09-30', 23050.8],
                      ['1999-12-31', 26583.9],
                      ['2000-03-31', 21329.9],
                      ['2000-06-30', 24043.4],
                      ['2000-09-30', 25712.5],
                      ['2000-12-31', 29194.3],
                      ['2001-03-31', 24086.4],
                      ['2001-06-30', 26726.6],
                      ['2001-09-30', 28333.3],
                      ['2001-12-31', 31716.8],
                      ['2002-03-31', 26295.0],
                      ['2002-06-30', 29194.8],
                      ['2002-09-30', 31257.3],
                      ['2002-12-31', 34970.3],
                      ['2003-03-31', 29825.5],
                      ['2003-06-30', 32537.3],
                      ['2003-09-30', 35291.9],
                      ['2003-12-31', 39767.4],
                      ['2004-03-31', 34544.6],
                      ['2004-06-30', 38700.8],
                      ['2004-09-30', 41855.0],
                      ['2004-12-31', 46739.8],
                      ['2005-03-31', 40453.3],
                      ['2005-06-30', 44793.1],
                      ['2005-09-30', 48047.8],
                      ['2005-12-31', 54024.8],
                      ['2006-03-31', 47078.9],
                      ['2006-06-30', 52673.3],
                      ['2006-09-30', 56064.7],
                      ['2006-12-31', 63621.6],
                      ['2007-03-31', 57159.3],
                      ['2007-06-30', 64781.6],
                      ['2007-09-30', 69482.1],
                      ['2007-12-31', 78669.3],
                      ['2008-03-31', 69373.6],
                      ['2008-06-30', 78711.8],
                      ['2008-09-30', 82460.1],
                      ['2008-12-31', 88699.0],
                      ['2009-03-31', 73979.2],
                      ['2009-06-30', 83865.8],
                      ['2009-09-30', 89846.9],
                      ['2009-12-31', 100825.8],
                      ['2010-03-31', 87501.3],
                      ['2010-06-30', 99347.4],
                      ['2010-09-30', 105963.7],
                      ['2010-12-31', 119306.8],
                      ['2011-03-31', 104469.9],
                      ['2011-06-30', 118895.9],
                      ['2011-09-30', 126562.2],
                      ['2011-12-31', 138012.1],
                      ['2012-03-31', 117357.6],
                      ['2012-06-30', 131320.6],
                      ['2012-09-30', 138089.6],
                      ['2012-12-31', 151812.0],
                      ['2013-03-31', 129449.6],
                      ['2013-06-30', 143518.7],
                      ['2013-09-30', 152222.7],
                      ['2013-12-31', 167772.3],
                      ['2014-03-31', 140759.8],
                      ['2014-06-30', 156489.6],
                      ['2014-09-30', 165484.7],
                      ['2014-12-31', 180828.9],
                      ['2015-03-31', 151137.9],
                      ['2015-06-30', 168549.7],
                      ['2015-09-30', 176597.7],
                      ['2015-12-31', 192572.9],
                      ['2016-03-31', 162410.0],
                      ['2016-06-30', 181408.2],
                      ['2016-09-30', 191010.6],
                      ['2016-12-31', 211566.2],
                      ['2017-03-31', 181867.7],
                      ['2017-06-30', 201950.3],
                      ['2017-09-30', 212789.3],
                      ['2017-12-31', 235428.7],
                      ['2018-03-31', 202035.7],
                      ['2018-06-30', 223962.2],
                      ['2018-09-30', 234474.3],
                      ['2018-12-31', 258808.9],
                      ['2019-03-31', 217168.3],
                      ['2019-06-30', 241502.6],
                      ['2019-09-30', 251046.3],
                      ['2019-12-31', 276798.0],
                      ['2020-03-31', 205727.0],
                      ['2020-06-30', 248985.1],
                      ['2020-09-30', 264976.3],
                      ['2020-12-31', 296297.8],
                      ['2021-03-31', 249310.1],
                      ['2021-06-30', 282857.4]]),
            columns=['date', 'gdp'])

        quarterly_gdp_df = quarterly_gdp_df.astype({
            'date': 'string',
            'gdp': 'float64'
        })

        return quarterly_gdp_df

    def macro_china_quarterly_gdp_yoy(self):

        quarterly_gdp_yoy_df = pd.DataFrame(
            np.array([['1993-03-31', 115.3],
                      ['1993-06-30', 113.5],
                      ['1993-09-30', 112.9],
                      ['1993-12-31', 114.1],
                      ['1994-03-31', 114.1],
                      ['1994-06-30', 113.3],
                      ['1994-09-30', 113.1],
                      ['1994-12-31', 112.0],
                      ['1995-03-31', 111.9],
                      ['1995-06-30', 111.0],
                      ['1995-09-30', 110.4],
                      ['1995-12-31', 110.8],
                      ['1996-03-31', 110.9],
                      ['1996-06-30', 109.4],
                      ['1996-09-30', 109.2],
                      ['1996-12-31', 110.3],
                      ['1997-03-31', 110.1],
                      ['1997-06-30', 110.0],
                      ['1997-09-30', 108.6],
                      ['1997-12-31', 108.6],
                      ['1998-03-31', 107.3],
                      ['1998-06-30', 106.9],
                      ['1998-09-30', 107.8],
                      ['1998-12-31', 109.1],
                      ['1999-03-31', 108.9],
                      ['1999-06-30', 107.9],
                      ['1999-09-30', 107.6],
                      ['1999-12-31', 106.7],
                      ['2000-03-31', 108.7],
                      ['2000-06-30', 109.1],
                      ['2000-09-30', 108.8],
                      ['2000-12-31', 107.5],
                      ['2001-03-31', 109.5],
                      ['2001-06-30', 108.6],
                      ['2001-09-30', 108.0],
                      ['2001-12-31', 107.5],
                      ['2002-03-31', 108.9],
                      ['2002-06-30', 108.8],
                      ['2002-09-30', 109.6],
                      ['2002-12-31', 109.1],
                      ['2003-03-31', 111.1],
                      ['2003-06-30', 109.1],
                      ['2003-09-30', 110.0],
                      ['2003-12-31', 110.0],
                      ['2004-03-31', 110.6],
                      ['2004-06-30', 111.6],
                      ['2004-09-30', 109.8],
                      ['2004-12-31', 108.8],
                      ['2005-03-31', 111.1],
                      ['2005-06-30', 111.1],
                      ['2005-09-30', 110.8],
                      ['2005-12-31', 112.4],
                      ['2006-03-31', 112.5],
                      ['2006-06-30', 113.7],
                      ['2006-09-30', 112.2],
                      ['2006-12-31', 112.5],
                      ['2007-03-31', 113.8],
                      ['2007-06-30', 115.0],
                      ['2007-09-30', 114.3],
                      ['2007-12-31', 113.9],
                      ['2008-03-31', 111.5],
                      ['2008-06-30', 110.9],
                      ['2008-09-30', 109.5],
                      ['2008-12-31', 107.1],
                      ['2009-03-31', 106.4],
                      ['2009-06-30', 108.2],
                      ['2009-09-30', 110.6],
                      ['2009-12-31', 111.9],
                      ['2010-03-31', 112.2],
                      ['2010-06-30', 110.8],
                      ['2010-09-30', 109.9],
                      ['2010-12-31', 109.9],
                      ['2011-03-31', 110.2],
                      ['2011-06-30', 110.0],
                      ['2011-09-30', 109.4],
                      ['2011-12-31', 108.8],
                      ['2012-03-31', 108.1],
                      ['2012-06-30', 107.7],
                      ['2012-09-30', 107.5],
                      ['2012-12-31', 108.1],
                      ['2013-03-31', 107.9],
                      ['2013-06-30', 107.6],
                      ['2013-09-30', 107.9],
                      ['2013-12-31', 107.7],
                      ['2014-03-31', 107.5],
                      ['2014-06-30', 107.6],
                      ['2014-09-30', 107.2],
                      ['2014-12-31', 107.3],
                      ['2015-03-31', 107.1],
                      ['2015-06-30', 107.1],
                      ['2015-09-30', 107.0],
                      ['2015-12-31', 106.9],
                      ['2016-03-31', 106.9],
                      ['2016-06-30', 106.8],
                      ['2016-09-30', 106.8],
                      ['2016-12-31', 106.9],
                      ['2017-03-31', 107.0],
                      ['2017-06-30', 107.0],
                      ['2017-09-30', 106.9],
                      ['2017-12-31', 106.8],
                      ['2018-03-31', 106.9],
                      ['2018-06-30', 106.9],
                      ['2018-09-30', 106.7],
                      ['2018-12-31', 106.5],
                      ['2019-03-31', 106.3],
                      ['2019-06-30', 106.0],
                      ['2019-09-30', 105.9],
                      ['2019-12-31', 105.8],
                      ['2020-03-31', 93.2],
                      ['2020-06-30', 103.2],
                      ['2020-09-30', 104.9],
                      ['2020-12-31', 106.5],
                      ['2021-03-31', 118.3],
                      ['2021-06-30', 107.9]]),
            columns=['date', 'gdp_yoy'])

        quarterly_gdp_yoy_df = quarterly_gdp_yoy_df.astype({
            'date': 'string',
            'gdp_yoy': 'float64'
        })

        return quarterly_gdp_yoy_df

    def macro_china_yearly_cpi_yoy(self):

        yearly_cpi_df = pd.DataFrame(
            np.array([[1951, 112.5],
                      [1952, 102.7],
                      [1953, 105.1],
                      [1954, 101.4],
                      [1955, 100.3],
                      [1956, 99.9],
                      [1957, 102.6],
                      [1958, 98.9],
                      [1959, 100.3],
                      [1960, 102.5],
                      [1961, 116.1],
                      [1962, 103.8],
                      [1963, 94.1],
                      [1964, 96.3],
                      [1965, 98.8],
                      [1966, 98.8],
                      [1967, 99.4],
                      [1968, 100.1],
                      [1969, 101.0],
                      [1970, 100.0],
                      [1971, 99.9],
                      [1972, 100.2],
                      [1973, 100.1],
                      [1974, 100.7],
                      [1975, 100.4],
                      [1976, 100.3],
                      [1977, 102.7],
                      [1978, 100.7],
                      [1979, 101.9],
                      [1980, 107.5],
                      [1981, 102.5],
                      [1982, 102.0],
                      [1983, 102.0],
                      [1984, 102.7],
                      [1985, 109.3],
                      [1986, 106.5],
                      [1987, 107.3],
                      [1988, 118.8],
                      [1989, 118.0],
                      [1990, 103.1],
                      [1991, 103.4],
                      [1992, 106.4],
                      [1993, 114.7],
                      [1994, 124.1],
                      [1995, 117.1],
                      [1996, 108.3],
                      [1997, 102.8],
                      [1998, 99.2],
                      [1999, 98.6],
                      [2000, 100.4],
                      [2001, 100.7],
                      [2002, 99.2],
                      [2003, 101.2],
                      [2004, 103.9],
                      [2005, 101.8],
                      [2006, 101.5],
                      [2007, 104.8],
                      [2008, 105.9],
                      [2009, 99.3],
                      [2010, 103.3],
                      [2011, 105.4],
                      [2012, 102.6],
                      [2013, 102.6],
                      [2014, 102.0],
                      [2015, 101.4],
                      [2016, 102.0],
                      [2017, 101.6],
                      [2018, 102.1],
                      [2019, 102.9],
                      [2020, 102.5]]),
            columns=['year', 'cpi'])

        yearly_cpi_df = yearly_cpi_df.astype({
            'year': 'int',
            'cpi': 'float64'
        })

        return yearly_cpi_df

    def macro_china_yearly_cpi_index(self):

        yearly_cpi_index_df = pd.DataFrame(
            np.array([[1978, 100.0],
                      [1979, 101.9],
                      [1980, 109.5],
                      [1981, 112.2],
                      [1982, 114.4],
                      [1983, 116.7],
                      [1984, 119.9],
                      [1985, 131.1],
                      [1986, 139.6],
                      [1987, 149.8],
                      [1988, 177.9],
                      [1989, 209.9],
                      [1990, 216.4],
                      [1991, 223.8],
                      [1992, 238.1],
                      [1993, 273.1],
                      [1994, 339.0],
                      [1995, 396.9],
                      [1996, 429.9],
                      [1997, 441.9],
                      [1998, 438.4],
                      [1999, 432.2],
                      [2000, 434.0],
                      [2001, 437.0],
                      [2002, 433.5],
                      [2003, 438.7],
                      [2004, 455.8],
                      [2005, 464.0],
                      [2006, 471.0],
                      [2007, 493.6],
                      [2008, 522.7],
                      [2009, 519.0],
                      [2010, 536.1],
                      [2011, 565.0],
                      [2012, 579.7],
                      [2013, 594.8],
                      [2014, 606.7],
                      [2015, 615.2],
                      [2016, 627.5],
                      [2017, 637.5],
                      [2018, 650.9],
                      [2019, 669.8],
                      [2020, 686.5]]),
            columns=['year', 'cpi_index'])

        yearly_cpi_index_df = yearly_cpi_index_df.astype({
            'year': 'int',
            'cpi_index': 'float64'
        })

        return yearly_cpi_index_df

    def macro_china_monthy_cpi_yoy(self):

        pass
