"""Traceback renderer with colored formatting."""

from __future__ import annotations

import traceback as _tb

from ..style.colors import Color


def render_traceback(exc: BaseException) -> None:
    header = f"{Color.get_color('error')}{Color.BOLD}Traceback (most recent call last):{Color.RESET}"
    print(header)
    tb = exc.__traceback__
    formatted = _tb.extract_tb(tb)
    for frame in formatted:
        file_str = f"{Color.get_color('muted')}File{Color.RESET} \"{frame.filename}\""
        line_str = f", line {frame.lineno}, in {Color.get_color('accent')}{frame.name}{Color.RESET}"
        print(f"  {file_str}{line_str}")
        if frame.line:
            print(f"    {Color.get_color('fg')}{frame.line.strip()}{Color.RESET}")
    print(f"{Color.get_color('error')}{type(exc).__name__}: {exc}{Color.RESET}")
