"""Jupyter integration helpers for Textforge.

Display ANSI strings as HTML or SVG inside notebooks using IPython display.
"""

from __future__ import annotations

from ..export import ansi_to_html, ansi_to_svg
from . import strip_ansi


def display_ansi_html(text: str) -> None:
    try:
        from IPython.display import HTML, display  # type: ignore (not required)
    except Exception:
        print(strip_ansi(text))
        return
    display(HTML(ansi_to_html(text)))


def display_ansi_svg(text: str) -> None:
    try:
        from IPython.display import SVG, display  # type: ignore (not required)
    except Exception:
        print(strip_ansi(text))
        return
    display(SVG(ansi_to_svg(text)))
