"""Debug overlay helpers to visualize layout boxes and constraints."""

from __future__ import annotations

from ..style.colors import Color


def overlay_box(width: int, height: int, margin: int = 0, padding: int = 0, color: str = "muted") -> None:
    col = Color.get_color(color)
    reset = Color.RESET
    inner_w = max(1, width - 2)
    top = "+" + "-" * inner_w + "+"
    print(col + top + reset)
    for _ in range(max(0, height - 2)):
        print(col + "|" + reset + " " * inner_w + col + "|" + reset)
    print(col + top + reset)
