"""Utility helpers for Textforge."""

from __future__ import annotations

from .accessibility import AccessibilityAPI
from .i18n import Translator, get_translator, register_translations, set_locale, t
from .input import read_key
from .io import iter_stdin_lines, read_stdin, read_text, write_text
from .text import (
    background_gradient_text,
    box_text,
    center_text,
    create_gradient_text,
    create_multi_gradient_text,
    format_text,
    get_visible_length,
    indent_text,
    justify_text,
    rainbow_text,
    strip_ansi,
    truncate_text,
    wrap_text,
    wrap_text_advanced,
)

__all__ = [
    "box_text",
    "center_text",
    "create_gradient_text",
    "create_multi_gradient_text",
    "background_gradient_text",
    "format_text",
    "get_visible_length",
    "indent_text",
    "justify_text",
    "rainbow_text",
    "strip_ansi",
    "truncate_text",
    "wrap_text",
    "wrap_text_advanced",
    "read_text",
    "write_text",
    "read_stdin",
    "iter_stdin_lines",
    "read_key",
    "AccessibilityAPI",
    "Translator",
    "get_translator",
    "set_locale",
    "register_translations",
    "t",
]
