"""Unicode-aware text engine facade for Textforge.

This module re-exports focused submodules:
- grapheme iteration and width in `textforge.graphemes`
- width/measurement helpers in `textforge.width`
- simple bidi in `textforge.bidi`

Backwards-compatible API is preserved for existing imports.
"""

from __future__ import annotations

from .bidi import bidi_reorder as bidi_reorder
from .graphemes import (
    grapheme_width as grapheme_width,
)
from .graphemes import (
    iter_graphemes as iter_graphemes,
)
from .graphemes import (
    next_grapheme as next_grapheme,
)
from .graphemes import (
    split_graphemes as split_graphemes,
)
from .width import (
    cell_width as cell_width,
)
from .width import (
    measure_text as measure_text,
)
from .width import (
    strip_ansi as strip_ansi,
)
from .width import (
    strip_markup as strip_markup,
)
from .width import (
    visible_width as visible_width,
)

__all__ = [
    "iter_graphemes",
    "split_graphemes",
    "next_grapheme",
    "grapheme_width",
    "cell_width",
    "visible_width",
    "strip_ansi",
    "strip_markup",
    "measure_text",
    "bidi_reorder",
]
