"""Dashboard templates (system monitor-like)."""

from __future__ import annotations

import random
from dataclasses import dataclass

from ..components import divider, grid, key_value, meter, paragraph, progress_bar, table, title
from ..core import composite, tfprint


@dataclass(slots=True)
class SystemOverviewConfig:
    width: int = 80
    title_color: str = "primary"
    header_color: str = "accent"


class Dashboard:
    @staticmethod
    def render_system_overview(cfg: SystemOverviewConfig):
        headers = ["Metric", "Value"]
        rows = [
            ["CPU", f"{random.randint(10, 95)} %"],
            ["Memory", f"{random.randint(2, 16)} GB"],
            ["Disk", f"{random.randint(20, 90)} %"],
        ]
        return composite(
            [
                title("SYSTEM OVERVIEW", width=cfg.width, symbol_style="rounded", color=cfg.title_color),
                paragraph("Live-like snapshot of system metrics (static demo).", width=cfg.width),
                divider(width=cfg.width),
                table(headers, rows, header_color=cfg.header_color),
                meter(random.random() * 100, label="CPU"),
                meter(random.random() * 100, label="GPU"),
                progress_bar(42, 100, label="Deploy", color="success"),
                divider(width=cfg.width),
                grid([["Services", "DB"], ["Cache", "Queue"]], cell_width=20, cell_height=2),
                key_value({"uptime": "3d 12h", "region": "us-east-1"}),
            ]
        )

    @staticmethod
    def system_overview(width: int = 80) -> None:
        tfprint(Dashboard.render_system_overview(SystemOverviewConfig(width=width)))
