"""CLI app templates: wizard setup and deployment dashboard."""

from __future__ import annotations

from ..components import Paragraph, ProgressBar, Table, Title
from ..components.containers import Box
from ..components.decorative import Divider


class CliApps:
    @staticmethod
    def wizard_setup(width: int = 80) -> None:
        Title.render("SETUP WIZARD", width=width, symbol_style="rounded", color="primary")
        Paragraph.render("Welcome to the wizard. This static preview shows typical steps.", width=width)
        Divider.render(width=width)
        steps = [
            ("Check environment", True),
            ("Install dependencies", True),
            ("Configure project", True),
            ("Initialize repo", False),
        ]
        rows = [[name, "OK" if ok else "PENDING"] for (name, ok) in steps]
        Table.render(["Step", "Status"], rows, header_color="accent")
        ProgressBar.render(3, 4, label="Progress", color="success")
        Box.render("Use arrow keys in interactive mode to proceed.", width=width, symbol_style="simple")

    @staticmethod
    def deploy_dashboard(width: int = 80) -> None:
        Title.render("DEPLOYMENT", width=width, symbol_style="rounded", color="accent")
        Paragraph.render("Static deployment dashboard (preview)", width=width)
        Divider.render(width=width)
        Table.render(["Service", "Version", "Status"], [["api", "1.4.2", "OK"], ["web", "2.1.0", "OK"], ["worker", "1.3.8", "OK"]], header_color="primary")
        ProgressBar.render(72, 100, label="Build", color="success")
        ProgressBar.render(25, 100, label="Migrate DB", color="warning")
        ProgressBar.render(0, 0, label="Health", indeterminate=True, frame=5, color="info")
