"""Design tokens for spacing and typography scales."""

from __future__ import annotations

SPACING_SCALE: dict[str, int] = {
    "none": 0,
    "xs": 1,
    "sm": 2,
    "md": 4,
    "lg": 6,
    "xl": 8,
}


TYPOGRAPHY_SCALE: dict[str, int] = {
    "xs": 1,
    "sm": 1,
    "md": 1,
    "lg": 1,
    "xl": 1,
}


__all__ = ["SPACING_SCALE", "TYPOGRAPHY_SCALE"]
