"""Gradient helpers for color interpolation."""

from __future__ import annotations

from .ansi import rgb_to_ansi


def blend(rgb_a: tuple[int, int, int], rgb_b: tuple[int, int, int], t: float) -> tuple[int, int, int]:
    t = max(0.0, min(1.0, t))
    return (
        int(rgb_a[0] + (rgb_b[0] - rgb_a[0]) * t),
        int(rgb_a[1] + (rgb_b[1] - rgb_a[1]) * t),
        int(rgb_a[2] + (rgb_b[2] - rgb_a[2]) * t),
    )


def apply_gradient(text: str, start_rgb: tuple[int, int, int], end_rgb: tuple[int, int, int]) -> str:
    if not text:
        return text
    n = len(text)
    out = []
    for i, ch in enumerate(text):
        ratio = i / max(1, n - 1)
        r, g, b = blend(start_rgb, end_rgb, ratio)
        out.append(f"{rgb_to_ansi((r, g, b))}{ch}")
    # Reset is appended by higher-level APIs when needed
    return "".join(out)


__all__ = ["blend", "apply_gradient"]
