"""Border symbol sets for different capabilities (Unicode vs ASCII)."""

from __future__ import annotations

UNICODE_BOX: dict[str, str] = {
    "h": "─",
    "v": "│",
    "tl": "┌",
    "tr": "┐",
    "bl": "└",
    "br": "┘",
    "t": "┬",
    "b": "┴",
    "l": "├",
    "r": "┤",
    "c": "┼",
}


ASCII_BOX: dict[str, str] = {
    "h": "-",
    "v": "|",
    "tl": "+",
    "tr": "+",
    "bl": "+",
    "br": "+",
    "t": "+",
    "b": "+",
    "l": "+",
    "r": "+",
    "c": "+",
}


def border_set(ascii_only: bool = False) -> dict[str, str]:
    return ASCII_BOX if ascii_only else UNICODE_BOX


__all__ = ["UNICODE_BOX", "ASCII_BOX", "border_set"]
