"""Plaintext exporter.

Converts ANSI to plain text by stripping escape sequences.
"""

from __future__ import annotations

import re


def ansi_to_text(text: str) -> str:
    return re.sub(r"\x1b\[[0-9;]*m", "", text)
