"""Optional OpenGL surface abstraction.

This provides types only; actual OpenGL bindings are not imported to avoid
external dependencies. A user can implement a concrete GL backend and pass it
into Window.on_paint or a custom renderer.
"""
from __future__ import annotations

from dataclasses import dataclass
from typing import Protocol


class GLContext(Protocol):
    def make_current(self) -> None: ...
    def swap_buffers(self) -> None: ...


@dataclass(slots=True)
class GLOptions:
    vsync: bool = True
    msaa_samples: int = 0


class GLSurface:
    def __init__(self, ctx: GLContext, opts: GLOptions | None = None) -> None:
        self.ctx = ctx
        self.opts = opts or GLOptions()

    def render_textframe(self, frame: str) -> None:
        # Placeholder: convert text frame to textured quads or vector path
        _ = frame
