from __future__ import annotations

import subprocess
from dataclasses import dataclass
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from collections.abc import Sequence


@dataclass(slots=True)
class ShellResult:
    code: int
    out: str
    err: str


def run_command(args: Sequence[str] | str, *, timeout: float | None = None, cwd: str | None = None) -> ShellResult:
    if isinstance(args, str):
        proc = subprocess.run(args, shell=True, capture_output=True, text=True, cwd=cwd, timeout=timeout)
    else:
        proc = subprocess.run(list(args), capture_output=True, text=True, cwd=cwd, timeout=timeout)
    return ShellResult(code=proc.returncode, out=proc.stdout, err=proc.stderr)
