"""Shared render tree primitives: VDOM, diff/patch, and contracts.

This package centralises the renderer-agnostic pieces used by both the
CLI/TTY renderer and any future GUI renderer. It re-exports the canonical
``Renderable`` protocol and ``Measure`` dataclass so renderers remain
swappable while using a single contract.
"""

from __future__ import annotations

# Canonical contracts (defined in core.console and re-exported here)
from ..console import Measure, Renderable, RenderableLike

# VDOM and diff/patch utilities (currently implemented in core.vdom)
from ..vdom import LineChange, Node, apply_changes, diff_changes, diff_lines

__all__ = [
    "Node",
    "LineChange",
    "diff_lines",
    "diff_changes",
    "apply_changes",
    "Renderable",
    "RenderableLike",
    "Measure",
]
