"""Core runtime primitives: console, renderables, VDOM and diffing."""

from __future__ import annotations

from .console import (
    CallableRenderable,
    CompositeRenderable,
    Console,
    LazyRenderable,
    Measure,
    Renderable,
    composite,
    lazy,
    render_call,
    tfprint,
    use_console,
)
from .render_tree import Node, apply_changes, diff_changes, diff_lines

__all__ = [
    "Console",
    "use_console",
    "Renderable",
    "Measure",
    "CallableRenderable",
    "CompositeRenderable",
    "LazyRenderable",
    "render_call",
    "composite",
    "lazy",
    "tfprint",
    "Node",
    "diff_lines",
    "diff_changes",
    "apply_changes",
]
