"""Common CLI error types and exit codes."""

from __future__ import annotations

from dataclasses import dataclass


@dataclass(slots=True)
class CLIError(Exception):
    message: str
    code: int = 1

    def __str__(self) -> str:
        return self.message


class ExitCode:
    OK = 0
    USAGE = 2
    RUNTIME_ERROR = 1
    IO_ERROR = 1
    NOT_FOUND = 1
