from __future__ import annotations

from typing import TYPE_CHECKING

from ...effects import Animation

if TYPE_CHECKING:
    import argparse


def _run(args: argparse.Namespace) -> None:
    Animation.typewriter(args.message, delay=args.delay, color=args.color)


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("typewriter", help="Play a typewriter animation")
    parser.add_argument("message", help="Message to animate")
    parser.add_argument("--delay", type=float, default=0.05, help="Delay between characters")
    parser.add_argument("--color", default=None, help="Optional text color")
    parser.set_defaults(func=_run)
