from __future__ import annotations

from typing import TYPE_CHECKING

from ...core import tfprint
from ...style.themes import ThemeManager

if TYPE_CHECKING:
    import argparse


def _run_list(_: argparse.Namespace) -> None:
    tfprint("Available themes:")
    for name in sorted(ThemeManager.available().keys()):
        tfprint(f"  - {name}")


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("theme", help="Theme operations")
    sub = parser.add_subparsers(dest="theme_cmd", required=True)
    p_list = sub.add_parser("list", help="List available themes")
    p_list.set_defaults(func=_run_list)
