from __future__ import annotations

import pathlib
from typing import TYPE_CHECKING

from ...markup.markdown import render_markdown
from ..errors import CLIError

if TYPE_CHECKING:
    import argparse


def _run(args: argparse.Namespace) -> None:
    try:
        md = pathlib.Path(args.path).read_text(encoding="utf-8")
    except Exception as e:
        raise CLIError(f"Failed to read '{args.path}': {e}") from e
    render_markdown(md)


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("preview", help="Preview a markdown file rendered with Textforge components")
    parser.add_argument("path", help="Path to markdown file")
    parser.set_defaults(func=_run)
