from __future__ import annotations

from typing import TYPE_CHECKING

from ...core import tfprint
from ...plugins import PluginRegistry

if TYPE_CHECKING:
    import argparse


def _run_list(_: argparse.Namespace) -> None:
    # Discover installed plugins via entry points before listing
    try:
        PluginRegistry.load_entry_points()
    except Exception:
        pass
    tfprint("Registered plugins:")
    for name in PluginRegistry.list():
        tfprint(f"  - {name}")


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("plugins", help="Plugin operations")
    sub = parser.add_subparsers(dest="plugins_cmd", required=True)
    p_list = sub.add_parser("list", help="List registered plugins")
    p_list.set_defaults(func=_run_list)
