from __future__ import annotations

from typing import TYPE_CHECKING

from ...core import tfprint
from ...markup import MarkupEngine

if TYPE_CHECKING:
    import argparse


def _run_list(_: argparse.Namespace) -> None:
    tags = MarkupEngine.list_global_tags()
    if not tags:
        tfprint("No custom tags registered.")
        return
    tfprint("Custom tags:")
    for name in tags:
        tfprint(f"  - {name}")


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("markup", help="Markup utilities")
    sub = parser.add_subparsers(dest="markup_cmd", required=True)
    p_list = sub.add_parser("list-tags", help="List registered custom markup tags")
    p_list.set_defaults(func=_run_list)
